/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.cql3.functions;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.cassandra.cql3.AssignmentTestable;
import org.apache.cassandra.cql3.CQL3Type;
import org.apache.cassandra.cql3.ColumnSpecification;
import org.apache.cassandra.cql3.Constants;
import org.apache.cassandra.cql3.CqlBuilder;
import org.apache.cassandra.cql3.Lists;
import org.apache.cassandra.cql3.Maps;
import org.apache.cassandra.cql3.QueryOptions;
import org.apache.cassandra.cql3.Sets;
import org.apache.cassandra.cql3.Term;
import org.apache.cassandra.cql3.Terms;
import org.apache.cassandra.cql3.UserTypes;
import org.apache.cassandra.cql3.VariableSpecifications;
import org.apache.cassandra.cql3.functions.Arguments;
import org.apache.cassandra.cql3.functions.CastFcts;
import org.apache.cassandra.cql3.functions.Function;
import org.apache.cassandra.cql3.functions.FunctionName;
import org.apache.cassandra.cql3.functions.FunctionResolver;
import org.apache.cassandra.cql3.functions.NativeFunctions;
import org.apache.cassandra.cql3.functions.OperationFcts;
import org.apache.cassandra.cql3.functions.ScalarFunction;
import org.apache.cassandra.cql3.statements.RequestValidations;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.db.marshal.CollectionType;
import org.apache.cassandra.db.marshal.ListType;
import org.apache.cassandra.db.marshal.MapType;
import org.apache.cassandra.db.marshal.SetType;
import org.apache.cassandra.db.marshal.UserType;
import org.apache.cassandra.exceptions.InvalidRequestException;
import org.apache.cassandra.serializers.MarshalException;
import org.apache.cassandra.utils.ByteBufferUtil;

public class FunctionCall
extends Term.NonTerminal {
    private final ScalarFunction fun;
    private final List<Term> terms;

    private FunctionCall(ScalarFunction fun, List<Term> terms) {
        this.fun = fun;
        this.terms = terms;
    }

    @Override
    public void addFunctionsTo(List<Function> functions) {
        Terms.addFunctions(this.terms, functions);
        this.fun.addFunctionsTo(functions);
    }

    @Override
    public void collectMarkerSpecification(VariableSpecifications boundNames) {
        for (Term t : this.terms) {
            t.collectMarkerSpecification(boundNames);
        }
    }

    @Override
    public Term.Terminal bind(QueryOptions options) throws InvalidRequestException {
        return FunctionCall.makeTerminal(this.fun, this.bindAndGet(options));
    }

    @Override
    public ByteBuffer bindAndGet(QueryOptions options) throws InvalidRequestException {
        Arguments arguments = this.fun.newArguments(options.getProtocolVersion());
        int m = this.terms.size();
        for (int i = 0; i < m; ++i) {
            Term t = this.terms.get(i);
            ByteBuffer argument = t.bindAndGet(options);
            RequestValidations.checkBindValueSet(argument, "Invalid unset value for argument in call to function %s", this.fun.name().name);
            arguments.set(i, argument);
        }
        return FunctionCall.executeInternal(this.fun, arguments);
    }

    private static ByteBuffer executeInternal(ScalarFunction fun, Arguments arguments) throws InvalidRequestException {
        ByteBuffer result = fun.execute(arguments);
        try {
            if (result != null) {
                fun.returnType().validate(result);
            }
            return result;
        }
        catch (MarshalException e) {
            throw new RuntimeException(String.format("Return of function %s (%s) is not a valid value for its declared return type %s", fun, ByteBufferUtil.bytesToHex(result), fun.returnType().asCQL3Type()), e);
        }
    }

    @Override
    public boolean containsBindMarker() {
        for (Term t : this.terms) {
            if (!t.containsBindMarker()) continue;
            return true;
        }
        return false;
    }

    private static Term.Terminal makeTerminal(Function fun, ByteBuffer result) throws InvalidRequestException {
        if (result == null) {
            return null;
        }
        if (fun.returnType().isCollection()) {
            switch (((CollectionType)fun.returnType()).kind) {
                case LIST: {
                    return Lists.Value.fromSerialized(result, (ListType)fun.returnType());
                }
                case SET: {
                    return Sets.Value.fromSerialized(result, (SetType)fun.returnType());
                }
                case MAP: {
                    return Maps.Value.fromSerialized(result, (MapType)fun.returnType());
                }
            }
        } else if (fun.returnType().isUDT()) {
            return UserTypes.Value.fromSerialized(result, (UserType)fun.returnType());
        }
        return new Constants.Value(result);
    }

    public static class Raw
    extends Term.Raw {
        private final FunctionName name;
        private final List<Term.Raw> terms;

        public Raw(FunctionName name, List<Term.Raw> terms) {
            this.name = name;
            this.terms = terms;
        }

        public static Raw newOperation(char operator, Term.Raw left, Term.Raw right) {
            FunctionName name = OperationFcts.getFunctionNameFromOperator(operator);
            return new Raw(name, Arrays.asList(left, right));
        }

        public static Raw newNegation(Term.Raw raw) {
            FunctionName name = FunctionName.nativeFunction("_negate");
            return new Raw(name, Collections.singletonList(raw));
        }

        public static Raw newCast(Term.Raw raw, CQL3Type type) {
            FunctionName name = FunctionName.nativeFunction(CastFcts.getFunctionName(type));
            return new Raw(name, Collections.singletonList(raw));
        }

        @Override
        public Term prepare(String keyspace, ColumnSpecification receiver) throws InvalidRequestException {
            Function fun = FunctionResolver.get(keyspace, this.name, this.terms, receiver.ksName, receiver.cfName, receiver.type);
            if (fun == null) {
                throw RequestValidations.invalidRequest("Unknown function %s called", this.name);
            }
            if (fun.isAggregate()) {
                throw RequestValidations.invalidRequest("Aggregation function are not supported in the where clause");
            }
            ScalarFunction scalarFun = (ScalarFunction)fun;
            if (!scalarFun.testAssignment(keyspace, receiver).isAssignable()) {
                if (OperationFcts.isOperation(this.name)) {
                    throw RequestValidations.invalidRequest("Type error: cannot assign result of operation %s (type %s) to %s (type %s)", Character.valueOf(OperationFcts.getOperator(scalarFun.name())), scalarFun.returnType().asCQL3Type(), receiver.name, receiver.type.asCQL3Type());
                }
                throw RequestValidations.invalidRequest("Type error: cannot assign result of function %s (type %s) to %s (type %s)", scalarFun.name(), scalarFun.returnType().asCQL3Type(), receiver.name, receiver.type.asCQL3Type());
            }
            if (fun.argTypes().size() != this.terms.size()) {
                throw RequestValidations.invalidRequest("Incorrect number of arguments specified for function %s (expected %d, found %d)", fun, fun.argTypes().size(), this.terms.size());
            }
            ArrayList<Term> parameters = new ArrayList<Term>(this.terms.size());
            for (int i = 0; i < this.terms.size(); ++i) {
                Term t = this.terms.get(i).prepare(keyspace, FunctionResolver.makeArgSpec(receiver.ksName, receiver.cfName, scalarFun, i));
                parameters.add(t);
            }
            return new FunctionCall(scalarFun, parameters);
        }

        @Override
        public AssignmentTestable.TestResult testAssignment(String keyspace, ColumnSpecification receiver) {
            try {
                Function fun = FunctionResolver.get(keyspace, this.name, this.terms, receiver.ksName, receiver.cfName, receiver.type);
                if (fun != null && NativeFunctions.instance.hasFactory(fun.name())) {
                    return AssignmentTestable.TestResult.WEAKLY_ASSIGNABLE;
                }
                if (fun != null && receiver.type.udfType().equals(fun.returnType())) {
                    return AssignmentTestable.TestResult.EXACT_MATCH;
                }
                if (fun == null || receiver.type.udfType().isValueCompatibleWith(fun.returnType())) {
                    return AssignmentTestable.TestResult.WEAKLY_ASSIGNABLE;
                }
                return AssignmentTestable.TestResult.NOT_ASSIGNABLE;
            }
            catch (InvalidRequestException e) {
                return AssignmentTestable.TestResult.WEAKLY_ASSIGNABLE;
            }
        }

        @Override
        public AbstractType<?> getExactTypeIfKnown(String keyspace) {
            try {
                Function fun = FunctionResolver.get(keyspace, this.name, this.terms, null, null, null);
                return fun == null ? null : fun.returnType();
            }
            catch (InvalidRequestException e) {
                return null;
            }
        }

        @Override
        public String getText() {
            CqlBuilder cqlNameBuilder = new CqlBuilder();
            this.name.appendCqlTo(cqlNameBuilder);
            return cqlNameBuilder + this.terms.stream().map(Term.Raw::getText).collect(Collectors.joining(", ", "(", ")"));
        }
    }
}

