/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db.guardrails;

import org.apache.cassandra.db.guardrails.GuardrailEvent;
import org.apache.cassandra.diag.DiagnosticEventService;

final class GuardrailsDiagnostics {
    private static final DiagnosticEventService service = DiagnosticEventService.instance();

    private GuardrailsDiagnostics() {
    }

    static void warned(String name, String message) {
        if (GuardrailsDiagnostics.isEnabled(GuardrailEvent.GuardrailEventType.WARNED)) {
            service.publish(new GuardrailEvent(GuardrailEvent.GuardrailEventType.WARNED, name, message));
        }
    }

    static void failed(String name, String message) {
        if (GuardrailsDiagnostics.isEnabled(GuardrailEvent.GuardrailEventType.FAILED)) {
            service.publish(new GuardrailEvent(GuardrailEvent.GuardrailEventType.FAILED, name, message));
        }
    }

    private static boolean isEnabled(GuardrailEvent.GuardrailEventType type) {
        return service.isEnabled(GuardrailEvent.class, type);
    }
}

