/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.stress.settings;

import com.google.common.base.Charsets;
import com.google.common.io.Resources;
import java.io.IOException;
import java.io.PrintStream;
import java.io.Serializable;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.cassandra.stress.generate.Distribution;
import org.apache.cassandra.stress.settings.CliOption;
import org.apache.cassandra.stress.settings.Command;
import org.apache.cassandra.stress.settings.GroupedOptions;
import org.apache.cassandra.stress.settings.Option;
import org.apache.cassandra.stress.settings.OptionDistribution;

class SettingsMisc
implements Serializable {
    SettingsMisc() {
    }

    static boolean maybeDoSpecial(Map<String, String[]> clArgs) {
        if (SettingsMisc.maybePrintHelp(clArgs)) {
            return true;
        }
        if (SettingsMisc.maybePrintDistribution(clArgs)) {
            return true;
        }
        return SettingsMisc.maybePrintVersion(clArgs);
    }

    private static boolean maybePrintDistribution(Map<String, String[]> clArgs) {
        String[] args = clArgs.get("print");
        if (args == null) {
            return false;
        }
        PrintDistribution dist = new PrintDistribution();
        if (null == GroupedOptions.select((String[])args, (GroupedOptions[])new PrintDistribution[]{dist})) {
            SettingsMisc.printHelpPrinter().run();
            System.out.println("Invalid print options provided, see output for valid options");
            System.exit(1);
        }
        SettingsMisc.printDistribution(dist.dist.get().get());
        return true;
    }

    private static void printDistribution(Distribution dist) {
        PrintStream out = System.out;
        out.println("% of samples    Range       % of total");
        String format = "%-16.1f%-12d%12.1f";
        double rangemax = (double)dist.inverseCumProb(1.0) / 100.0;
        for (double d : new double[]{0.1, 0.2, 0.3, 0.4, 0.5, 0.6, 0.7, 0.8, 0.9, 0.95, 0.99, 1.0}) {
            double sampleperc = d * 100.0;
            long max = dist.inverseCumProb(d);
            double rangeperc = (double)max / rangemax;
            out.println(String.format(format, sampleperc, max, rangeperc));
        }
    }

    private static boolean maybePrintHelp(Map<String, String[]> clArgs) {
        if (!clArgs.containsKey("-?") && !clArgs.containsKey("help")) {
            return false;
        }
        String[] params = clArgs.remove("-?");
        if (params == null) {
            params = clArgs.remove("help");
        }
        if (params.length == 0) {
            if (!clArgs.isEmpty()) {
                String p;
                if (clArgs.size() == 1 && clArgs.get(p = clArgs.keySet().iterator().next()).length == 0) {
                    params = new String[]{p};
                }
            } else {
                SettingsMisc.printHelp();
                return true;
            }
        }
        if (params.length == 1) {
            SettingsMisc.printHelp(params[0]);
            return true;
        }
        throw new IllegalArgumentException("Invalid command/option provided to help");
    }

    private static boolean maybePrintVersion(Map<String, String[]> clArgs) {
        if (clArgs.containsKey("version")) {
            try {
                URL url = Resources.getResource((String)"org/apache/cassandra/config/version.properties");
                System.out.println(SettingsMisc.parseVersionFile(Resources.toString((URL)url, (Charset)Charsets.UTF_8)));
            }
            catch (IOException e) {
                e.printStackTrace(System.err);
            }
            return true;
        }
        return false;
    }

    static String parseVersionFile(String versionFileContents) {
        Matcher matcher = Pattern.compile(".*?CassandraVersion=(.*?)$").matcher(versionFileContents);
        if (matcher.find()) {
            return "Version: " + matcher.group(1);
        }
        return "Unable to find version information";
    }

    public static void printHelp() {
        System.out.println("Usage:      cassandra-stress <command> [options]");
        System.out.println("Help usage: cassandra-stress help <command>");
        System.out.println();
        System.out.println("---Commands---");
        for (Command command : Command.values()) {
            System.out.println(String.format("%-20s : %s", command.toString().toLowerCase(), command.description));
        }
        System.out.println();
        System.out.println("---Options---");
        for (Enum enum_ : CliOption.values()) {
            System.out.println(String.format("-%-20s : %s", enum_.toString().toLowerCase(), ((CliOption)enum_).description));
        }
    }

    public static void printHelp(String command) {
        Command cmd = Command.get(command);
        if (cmd != null) {
            cmd.printHelp();
            return;
        }
        CliOption opt = CliOption.get(command);
        if (opt != null) {
            opt.printHelp();
            return;
        }
        SettingsMisc.printHelp();
        throw new IllegalArgumentException("Invalid command or option provided to command help");
    }

    static Runnable helpHelpPrinter() {
        return () -> {
            System.out.println("Usage: ./bin/cassandra-stress help <command|option>");
            System.out.println("Commands:");
            for (Command command : Command.values()) {
                System.out.println("    " + command.names.toString().replaceAll("\\[|\\]", ""));
            }
            System.out.println("Options:");
            for (Enum enum_ : CliOption.values()) {
                System.out.println("    -" + enum_.toString().toLowerCase() + (((CliOption)enum_).extraName != null ? ", " + ((CliOption)enum_).extraName : ""));
            }
        };
    }

    static Runnable printHelpPrinter() {
        return () -> GroupedOptions.printOptions(System.out, "print", new GroupedOptions(){

            @Override
            public List<? extends Option> options() {
                return Arrays.asList(new OptionDistribution("dist=", null, "A mathematical distribution"));
            }
        });
    }

    static Runnable sendToDaemonHelpPrinter() {
        return () -> {
            System.out.println("Usage: -sendto <host>");
            System.out.println();
            System.out.println("Specify a host running the stress server to send this stress command to");
        };
    }

    static String getSendToDaemon(Map<String, String[]> clArgs) {
        Object[] params = clArgs.remove("-send-to");
        if (params == null) {
            params = clArgs.remove("-sendto");
        }
        if (params == null) {
            return null;
        }
        if (params.length != 1) {
            SettingsMisc.sendToDaemonHelpPrinter().run();
            System.out.println("Invalid -sendto specifier: " + Arrays.toString(params));
            System.exit(1);
        }
        return params[0];
    }

    private static final class PrintDistribution
    extends GroupedOptions {
        final OptionDistribution dist = new OptionDistribution("dist=", null, "A mathematical distribution");

        private PrintDistribution() {
        }

        @Override
        public List<? extends Option> options() {
            return Arrays.asList(this.dist);
        }
    }
}

