/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.auth;

import org.apache.cassandra.auth.AllowAllAuthenticator;
import org.apache.cassandra.auth.AllowAllAuthorizer;
import org.apache.cassandra.auth.AllowAllInternodeAuthenticator;
import org.apache.cassandra.auth.CassandraRoleManager;
import org.apache.cassandra.auth.IAuthenticator;
import org.apache.cassandra.auth.IAuthorizer;
import org.apache.cassandra.auth.IInternodeAuthenticator;
import org.apache.cassandra.auth.IRoleManager;
import org.apache.cassandra.auth.PasswordAuthenticator;
import org.apache.cassandra.config.Config;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.exceptions.ConfigurationException;
import org.apache.cassandra.utils.FBUtilities;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class AuthConfig {
    private static final Logger logger = LoggerFactory.getLogger(AuthConfig.class);
    private static boolean initialized;

    public static void applyAuth() {
        if (initialized) {
            return;
        }
        initialized = true;
        Config conf = DatabaseDescriptor.getRawConfig();
        IAuthenticator authenticator = new AllowAllAuthenticator();
        if (conf.authenticator != null) {
            authenticator = FBUtilities.newAuthenticator(conf.authenticator);
        }
        if (!(authenticator instanceof PasswordAuthenticator || conf.credentials_update_interval_in_ms == -1 && conf.credentials_validity_in_ms == 2000 && conf.credentials_cache_max_entries == 1000)) {
            logger.info("Configuration options credentials_update_interval_in_ms, credentials_validity_in_ms and credentials_cache_max_entries may not be applicable for the configured authenticator ({})", (Object)authenticator.getClass().getName());
        }
        DatabaseDescriptor.setAuthenticator(authenticator);
        IAuthorizer authorizer = new AllowAllAuthorizer();
        if (conf.authorizer != null) {
            authorizer = FBUtilities.newAuthorizer(conf.authorizer);
        }
        if (!authenticator.requireAuthentication() && authorizer.requireAuthorization()) {
            throw new ConfigurationException(conf.authenticator + " can't be used with " + conf.authorizer, false);
        }
        DatabaseDescriptor.setAuthorizer(authorizer);
        IRoleManager roleManager = conf.role_manager != null ? FBUtilities.newRoleManager(conf.role_manager) : new CassandraRoleManager();
        if (authenticator instanceof PasswordAuthenticator && !(roleManager instanceof CassandraRoleManager)) {
            throw new ConfigurationException("CassandraRoleManager must be used with PasswordAuthenticator", false);
        }
        DatabaseDescriptor.setRoleManager(roleManager);
        IInternodeAuthenticator internodeAuthenticator = conf.internode_authenticator != null ? (IInternodeAuthenticator)FBUtilities.construct(conf.internode_authenticator, "internode_authenticator") : new AllowAllInternodeAuthenticator();
        DatabaseDescriptor.setInternodeAuthenticator(internodeAuthenticator);
        authenticator.validateConfiguration();
        authorizer.validateConfiguration();
        roleManager.validateConfiguration();
        internodeAuthenticator.validateConfiguration();
    }
}

