/*
 * Decompiled with CFR 0.152.
 */
package com.clearspring.analytics.stream.cardinality;

import com.clearspring.analytics.hash.MurmurHash;
import com.clearspring.analytics.stream.cardinality.CardinalityMergeException;
import com.clearspring.analytics.stream.cardinality.ICardinality;
import com.clearspring.analytics.stream.cardinality.RegisterSet;
import com.clearspring.analytics.util.Bits;
import com.clearspring.analytics.util.IBuilder;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.Serializable;

public class HyperLogLog
implements ICardinality {
    private final RegisterSet registerSet;
    private final int log2m;
    private final double alphaMM;

    public HyperLogLog(double rsd) {
        this(HyperLogLog.log2m(rsd));
    }

    private static int log2m(double rsd) {
        return (int)(Math.log(1.106 / rsd * (1.106 / rsd)) / Math.log(2.0));
    }

    public HyperLogLog(int log2m) {
        this(log2m, new RegisterSet((int)Math.pow(2.0, log2m)));
    }

    public HyperLogLog(int log2m, RegisterSet registerSet) {
        this.registerSet = registerSet;
        this.log2m = log2m;
        int m = (int)Math.pow(2.0, this.log2m);
        switch (log2m) {
            case 4: {
                this.alphaMM = 0.673 * (double)m * (double)m;
                break;
            }
            case 5: {
                this.alphaMM = 0.697 * (double)m * (double)m;
                break;
            }
            case 6: {
                this.alphaMM = 0.709 * (double)m * (double)m;
                break;
            }
            default: {
                this.alphaMM = 0.7213 / (1.0 + 1.079 / (double)m) * (double)m * (double)m;
            }
        }
    }

    @Override
    public boolean offerHashed(long hashedValue) {
        int j = (int)(hashedValue >>> 64 - this.log2m);
        int r = Long.numberOfLeadingZeros(hashedValue << this.log2m | (long)((1 << this.log2m - 1) + 1)) + 1;
        return this.registerSet.updateIfGreater(j, r);
    }

    @Override
    public boolean offerHashed(int hashedValue) {
        int j = hashedValue >>> 32 - this.log2m;
        int r = Integer.numberOfLeadingZeros(hashedValue << this.log2m | (1 << this.log2m - 1) + 1) + 1;
        return this.registerSet.updateIfGreater(j, r);
    }

    @Override
    public boolean offer(Object o) {
        int x = MurmurHash.hash(o);
        return this.offerHashed(x);
    }

    @Override
    public long cardinality() {
        double registerSum = 0.0;
        int count = this.registerSet.count;
        double zeros = 0.0;
        for (int j = 0; j < this.registerSet.count; ++j) {
            int val = this.registerSet.get(j);
            registerSum += 1.0 / (double)(1 << val);
            if (val != 0) continue;
            zeros += 1.0;
        }
        double estimate = this.alphaMM * (1.0 / registerSum);
        if (estimate <= 2.5 * (double)count) {
            return Math.round((double)count * Math.log((double)count / zeros));
        }
        return Math.round(estimate);
    }

    @Override
    public int sizeof() {
        return this.registerSet.size * 4;
    }

    @Override
    public byte[] getBytes() throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DataOutputStream dos = new DataOutputStream(baos);
        dos.writeInt(this.log2m);
        dos.writeInt(this.registerSet.size * 4);
        for (int x : this.registerSet.bits()) {
            dos.writeInt(x);
        }
        return baos.toByteArray();
    }

    public void addAll(HyperLogLog other) throws CardinalityMergeException {
        if (this.sizeof() != other.sizeof()) {
            throw new HyperLogLogMergeException("Cannot merge estimators of different sizes");
        }
        this.registerSet.merge(other.registerSet);
    }

    @Override
    public ICardinality merge(ICardinality ... estimators) throws CardinalityMergeException {
        HyperLogLog merged = new HyperLogLog(this.log2m);
        merged.addAll(this);
        if (estimators == null) {
            return merged;
        }
        for (ICardinality estimator : estimators) {
            if (!(estimator instanceof HyperLogLog)) {
                throw new HyperLogLogMergeException("Cannot merge estimators of different class");
            }
            HyperLogLog hll = (HyperLogLog)estimator;
            merged.addAll(hll);
        }
        return merged;
    }

    protected static class HyperLogLogMergeException
    extends CardinalityMergeException {
        public HyperLogLogMergeException(String message) {
            super(message);
        }
    }

    public static class Builder
    implements IBuilder<ICardinality>,
    Serializable {
        private double rsd;

        public Builder(double rsd) {
            this.rsd = rsd;
        }

        @Override
        public HyperLogLog build() {
            return new HyperLogLog(this.rsd);
        }

        @Override
        public int sizeof() {
            int log2m = HyperLogLog.log2m(this.rsd);
            int k = (int)Math.pow(2.0, log2m);
            return RegisterSet.getBits(k) * 4;
        }

        public static HyperLogLog build(byte[] bytes) throws IOException {
            ByteArrayInputStream bais = new ByteArrayInputStream(bytes);
            DataInputStream oi = new DataInputStream(bais);
            int log2m = oi.readInt();
            int size = oi.readInt();
            byte[] longArrayBytes = new byte[size];
            oi.readFully(longArrayBytes);
            return new HyperLogLog(log2m, new RegisterSet((int)Math.pow(2.0, log2m), Bits.getBits(longArrayBytes)));
        }
    }
}

