/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.vault.aot;

import java.io.IOException;
import java.util.stream.Stream;
import org.springframework.aot.hint.MemberCategory;
import org.springframework.aot.hint.ReflectionHints;
import org.springframework.aot.hint.RuntimeHints;
import org.springframework.aot.hint.RuntimeHintsRegistrar;
import org.springframework.aot.hint.TypeReference;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.core.type.classreading.CachingMetadataReaderFactory;
import org.springframework.core.type.classreading.MetadataReader;
import org.springframework.util.ClassUtils;

class VaultRuntimeHints
implements RuntimeHintsRegistrar {
    private final CachingMetadataReaderFactory factory = new CachingMetadataReaderFactory();

    VaultRuntimeHints() {
    }

    public void registerHints(RuntimeHints hints, ClassLoader classLoader) {
        PathMatchingResourcePatternResolver resolver = new PathMatchingResourcePatternResolver(classLoader);
        ReflectionHints reflection = hints.reflection();
        MemberCategory[] dataObjectCategories = new MemberCategory[]{MemberCategory.DECLARED_FIELDS, MemberCategory.INVOKE_DECLARED_METHODS, MemberCategory.INVOKE_DECLARED_CONSTRUCTORS, MemberCategory.INTROSPECT_DECLARED_CONSTRUCTORS, MemberCategory.INTROSPECT_DECLARED_METHODS};
        try {
            Resource[] resources;
            for (Resource resource : resources = resolver.getResources("classpath*:" + ClassUtils.convertClassNameToResourcePath((String)"org.springframework.vault.support") + "/*.class")) {
                MetadataReader metadataReader = this.factory.getMetadataReader(resource);
                String className = metadataReader.getClassMetadata().getClassName();
                if (className.contains("-")) continue;
                reflection.registerType(TypeReference.of((String)className), dataObjectCategories);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        Stream.of("org.springframework.vault.core.VaultSysTemplate$GetMounts$VaultMountsResponse", "org.springframework.vault.core.VaultVersionedKeyValueTemplate$VersionedResponse", "org.springframework.vault.core.ReactiveVaultTemplate$VaultListResponse", "org.springframework.vault.core.VaultListResponse", "org.springframework.vault.core.VaultTransitTemplate$RawTransitKeyImpl", "org.springframework.vault.core.VaultTransitTemplate$VaultTransitKeyImpl", "org.springframework.vault.core.VaultSysTemplate$GetMounts", "org.springframework.vault.core.VaultSysTemplate$GetUnsealStatus", "org.springframework.vault.core.VaultSysTemplate$Health", "org.springframework.vault.core.VaultSysTemplate$Seal", "org.springframework.vault.core.VaultSysTemplate$VaultHealthImpl", "org.springframework.vault.core.VaultSysTemplate$VaultInitializationResponseImpl", "org.springframework.vault.core.VaultSysTemplate$VaultUnsealStatusImpl", "org.springframework.vault.core.VaultVersionedKeyValueTemplate$VersionedResponse").forEach(cls -> reflection.registerType(TypeReference.of((String)cls), dataObjectCategories));
        reflection.registerTypeIfPresent(classLoader, "com.google.api.client.json.jackson2.JacksonFactory", new MemberCategory[]{MemberCategory.INVOKE_DECLARED_CONSTRUCTORS, MemberCategory.INVOKE_PUBLIC_CONSTRUCTORS});
        reflection.registerTypeIfPresent(classLoader, "com.google.api.client.json.gson.GsonFactory", new MemberCategory[]{MemberCategory.INVOKE_DECLARED_CONSTRUCTORS, MemberCategory.INVOKE_PUBLIC_CONSTRUCTORS});
    }
}

