/*
 * Decompiled with CFR 0.152.
 */
package org.apache.airavata.gfac.impl.job;

import java.io.File;
import java.util.Map;
import org.apache.airavata.gfac.core.JobManagerConfiguration;
import org.apache.airavata.gfac.core.cluster.OutputParser;
import org.apache.airavata.gfac.core.cluster.RawCommandInfo;
import org.apache.airavata.model.appcatalog.computeresource.JobManagerCommand;
import org.apache.commons.io.FilenameUtils;

public class ForkJobConfiguration
implements JobManagerConfiguration {
    private final Map<JobManagerCommand, String> jobManagerCommands;
    private String jobDescriptionTemplateName;
    private String scriptExtension;
    private String installedPath;
    private OutputParser parser;

    public ForkJobConfiguration(String jobDescriptionTemplateName, String scriptExtension, String installedPath, Map<JobManagerCommand, String> jobManagerCommands, OutputParser parser) {
        this.jobDescriptionTemplateName = jobDescriptionTemplateName;
        this.scriptExtension = scriptExtension;
        this.parser = parser;
        installedPath = installedPath.trim();
        this.installedPath = installedPath.endsWith("/") ? installedPath : installedPath + "/";
        this.jobManagerCommands = jobManagerCommands;
    }

    public RawCommandInfo getCancelCommand(String jobID) {
        return new RawCommandInfo(this.installedPath + this.jobManagerCommands.get(JobManagerCommand.DELETION).trim() + " " + jobID);
    }

    public String getJobDescriptionTemplateName() {
        return this.jobDescriptionTemplateName;
    }

    public RawCommandInfo getMonitorCommand(String jobID) {
        return null;
    }

    public RawCommandInfo getUserBasedMonitorCommand(String userName) {
        return null;
    }

    public RawCommandInfo getJobIdMonitorCommand(String jobName, String userName) {
        return null;
    }

    public String getScriptExtension() {
        return this.scriptExtension;
    }

    public RawCommandInfo getSubmitCommand(String workingDirectory, String forkFilePath) {
        return new RawCommandInfo(this.installedPath + this.jobManagerCommands.get(JobManagerCommand.SUBMISSION).trim() + " " + workingDirectory + File.separator + FilenameUtils.getName((String)forkFilePath));
    }

    public OutputParser getParser() {
        return this.parser;
    }

    public String getInstalledPath() {
        return this.installedPath;
    }

    public String getBaseCancelCommand() {
        return null;
    }

    public String getBaseMonitorCommand() {
        return null;
    }

    public String getBaseSubmitCommand() {
        return null;
    }
}

