/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.dynamodbv2.datamodeling.unmarshallers;

import com.amazonaws.services.dynamodbv2.datamodeling.unmarshallers.NSUnmarshaller;
import com.amazonaws.services.dynamodbv2.model.AttributeValue;
import java.util.HashSet;
import java.util.List;

public class BooleanSetUnmarshaller
extends NSUnmarshaller {
    private static final BooleanSetUnmarshaller INSTANCE = new BooleanSetUnmarshaller();

    public static BooleanSetUnmarshaller instance() {
        return INSTANCE;
    }

    private BooleanSetUnmarshaller() {
    }

    @Override
    public Object unmarshall(AttributeValue value) {
        List<String> values = value.getNS();
        HashSet<Boolean> result = new HashSet<Boolean>();
        for (String s : values) {
            if ("1".equals(s)) {
                result.add(Boolean.TRUE);
                continue;
            }
            if ("0".equals(s)) {
                result.add(Boolean.FALSE);
                continue;
            }
            throw new IllegalArgumentException("Expected '1' or '0' for boolean value, was " + s);
        }
        return result;
    }
}

