/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.dynamodbv2.datamodeling;

import com.amazonaws.metrics.RequestMetricCollector;
import com.amazonaws.services.dynamodbv2.datamodeling.ConversionSchema;
import com.amazonaws.services.dynamodbv2.datamodeling.ConversionSchemas;

public class DynamoDBMapperConfig {
    private final SaveBehavior saveBehavior;
    private final ConsistentReads consistentReads;
    private final TableNameOverride tableNameOverride;
    private final PaginationLoadingStrategy paginationLoadingStrategy;
    private final RequestMetricCollector requestMetricCollector;
    private final ConversionSchema conversionSchema;
    public static final DynamoDBMapperConfig DEFAULT = new DynamoDBMapperConfig(SaveBehavior.UPDATE, ConsistentReads.EVENTUAL, null, PaginationLoadingStrategy.LAZY_LOADING, null, ConversionSchemas.DEFAULT);

    @Deprecated
    public DynamoDBMapperConfig(SaveBehavior saveBehavior, ConsistentReads consistentReads, TableNameOverride tableNameOverride) {
        this(saveBehavior, consistentReads, tableNameOverride, null, null);
    }

    @Deprecated
    public DynamoDBMapperConfig(SaveBehavior saveBehavior, ConsistentReads consistentReads, TableNameOverride tableNameOverride, PaginationLoadingStrategy paginationLoadingStrategy) {
        this(saveBehavior, consistentReads, tableNameOverride, paginationLoadingStrategy, null);
    }

    @Deprecated
    public DynamoDBMapperConfig(SaveBehavior saveBehavior, ConsistentReads consistentReads, TableNameOverride tableNameOverride, PaginationLoadingStrategy paginationLoadingStrategy, RequestMetricCollector requestMetricCollector) {
        this(saveBehavior, consistentReads, tableNameOverride, paginationLoadingStrategy, requestMetricCollector, ConversionSchemas.DEFAULT);
    }

    private DynamoDBMapperConfig(SaveBehavior saveBehavior, ConsistentReads consistentReads, TableNameOverride tableNameOverride, PaginationLoadingStrategy paginationLoadingStrategy, RequestMetricCollector requestMetricCollector, ConversionSchema conversionSchema) {
        this.saveBehavior = saveBehavior;
        this.consistentReads = consistentReads;
        this.tableNameOverride = tableNameOverride;
        this.paginationLoadingStrategy = paginationLoadingStrategy;
        this.requestMetricCollector = requestMetricCollector;
        this.conversionSchema = conversionSchema;
    }

    public DynamoDBMapperConfig(SaveBehavior saveBehavior) {
        this(saveBehavior, null, null, null, null, ConversionSchemas.DEFAULT);
    }

    public DynamoDBMapperConfig(ConsistentReads consistentReads) {
        this(null, consistentReads, null, null, null, ConversionSchemas.DEFAULT);
    }

    public DynamoDBMapperConfig(TableNameOverride tableNameOverride) {
        this(null, null, tableNameOverride, null, null, ConversionSchemas.DEFAULT);
    }

    public DynamoDBMapperConfig(PaginationLoadingStrategy paginationLoadingStrategy) {
        this(null, null, null, paginationLoadingStrategy, null, ConversionSchemas.DEFAULT);
    }

    public DynamoDBMapperConfig(ConversionSchema conversionSchema) {
        this(null, null, null, null, null, conversionSchema);
    }

    public DynamoDBMapperConfig(DynamoDBMapperConfig defaults, DynamoDBMapperConfig overrides) {
        if (overrides == null) {
            this.saveBehavior = defaults.getSaveBehavior();
            this.consistentReads = defaults.getConsistentReads();
            this.tableNameOverride = defaults.getTableNameOverride();
            this.paginationLoadingStrategy = defaults.getPaginationLoadingStrategy();
            this.requestMetricCollector = defaults.getRequestMetricCollector();
            this.conversionSchema = defaults.getConversionSchema();
        } else {
            this.saveBehavior = overrides.getSaveBehavior() == null ? defaults.getSaveBehavior() : overrides.getSaveBehavior();
            this.consistentReads = overrides.getConsistentReads() == null ? defaults.getConsistentReads() : overrides.getConsistentReads();
            this.tableNameOverride = overrides.getTableNameOverride() == null ? defaults.getTableNameOverride() : overrides.getTableNameOverride();
            this.paginationLoadingStrategy = overrides.getPaginationLoadingStrategy() == null ? defaults.getPaginationLoadingStrategy() : overrides.getPaginationLoadingStrategy();
            this.requestMetricCollector = overrides.getRequestMetricCollector() == null ? defaults.getRequestMetricCollector() : overrides.getRequestMetricCollector();
            this.conversionSchema = overrides.getConversionSchema() == null ? defaults.getConversionSchema() : overrides.getConversionSchema();
        }
    }

    public SaveBehavior getSaveBehavior() {
        return this.saveBehavior;
    }

    public ConsistentReads getConsistentReads() {
        return this.consistentReads;
    }

    public TableNameOverride getTableNameOverride() {
        return this.tableNameOverride;
    }

    public PaginationLoadingStrategy getPaginationLoadingStrategy() {
        return this.paginationLoadingStrategy;
    }

    public RequestMetricCollector getRequestMetricCollector() {
        return this.requestMetricCollector;
    }

    public ConversionSchema getConversionSchema() {
        return this.conversionSchema;
    }

    public static final class TableNameOverride {
        private final String tableNameOverride;
        private final String tableNamePrefix;

        public static TableNameOverride withTableNamePrefix(String tableNamePrefix) {
            return new TableNameOverride(null, tableNamePrefix);
        }

        public static TableNameOverride withTableNameReplacement(String tableNameReplacement) {
            return new TableNameOverride(tableNameReplacement, null);
        }

        private TableNameOverride(String tableNameOverride, String tableNamePrefix) {
            this.tableNameOverride = tableNameOverride;
            this.tableNamePrefix = tableNamePrefix;
        }

        public TableNameOverride(String tableNameOverride) {
            this(tableNameOverride, null);
        }

        public String getTableName() {
            return this.tableNameOverride;
        }

        public String getTableNamePrefix() {
            return this.tableNamePrefix;
        }
    }

    public static enum PaginationLoadingStrategy {
        LAZY_LOADING,
        ITERATION_ONLY,
        EAGER_LOADING;

    }

    public static enum ConsistentReads {
        CONSISTENT,
        EVENTUAL;

    }

    public static enum SaveBehavior {
        UPDATE,
        UPDATE_SKIP_NULL_ATTRIBUTES,
        CLOBBER,
        APPEND_SET;

    }

    public static class Builder {
        private SaveBehavior saveBehavior = DEFAULT.getSaveBehavior();
        private ConsistentReads consistentReads = DEFAULT.getConsistentReads();
        private TableNameOverride tableNameOverride = DEFAULT.getTableNameOverride();
        private PaginationLoadingStrategy paginationLoadingStrategy = DEFAULT.getPaginationLoadingStrategy();
        private RequestMetricCollector requestMetricCollector = DEFAULT.getRequestMetricCollector();
        private ConversionSchema conversionSchema = DEFAULT.getConversionSchema();

        public SaveBehavior getSaveBehavior() {
            return this.saveBehavior;
        }

        public void setSaveBehavior(SaveBehavior value) {
            this.saveBehavior = value;
        }

        public Builder withSaveBehavior(SaveBehavior value) {
            this.setSaveBehavior(value);
            return this;
        }

        public ConsistentReads getConsistentReads() {
            return this.consistentReads;
        }

        public void setConsistentReads(ConsistentReads value) {
            this.consistentReads = value;
        }

        public Builder withConsistentReads(ConsistentReads value) {
            this.setConsistentReads(value);
            return this;
        }

        public TableNameOverride getTableNameOverride() {
            return this.tableNameOverride;
        }

        public void setTableNameOverride(TableNameOverride value) {
            this.tableNameOverride = value;
        }

        public Builder withTableNameOverride(TableNameOverride value) {
            this.setTableNameOverride(value);
            return this;
        }

        public PaginationLoadingStrategy getPaginationLoadingStrategy() {
            return this.paginationLoadingStrategy;
        }

        public void setPaginationLoadingStrategy(PaginationLoadingStrategy value) {
            this.paginationLoadingStrategy = value;
        }

        public Builder withPaginationLoadingStrategy(PaginationLoadingStrategy value) {
            this.setPaginationLoadingStrategy(value);
            return this;
        }

        public RequestMetricCollector getRequestMetricCollector() {
            return this.requestMetricCollector;
        }

        public void setRequestMetricCollector(RequestMetricCollector value) {
            this.requestMetricCollector = value;
        }

        public Builder withRequestMetricCollector(RequestMetricCollector value) {
            this.setRequestMetricCollector(value);
            return this;
        }

        public ConversionSchema getConversionSchema() {
            return this.conversionSchema;
        }

        public void setConversionSchema(ConversionSchema value) {
            this.conversionSchema = value;
        }

        public Builder withConversionSchema(ConversionSchema value) {
            this.setConversionSchema(value);
            return this;
        }

        public DynamoDBMapperConfig build() {
            return new DynamoDBMapperConfig(this.saveBehavior, this.consistentReads, this.tableNameOverride, this.paginationLoadingStrategy, this.requestMetricCollector, this.conversionSchema);
        }
    }
}

