/*
 * Decompiled with CFR 0.152.
 */
package org.xerial.snappy;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Enumeration;
import java.util.Properties;
import java.util.UUID;
import org.xerial.snappy.OSInfo;
import org.xerial.snappy.SnappyError;
import org.xerial.snappy.SnappyErrorCode;
import org.xerial.snappy.SnappyNative;

public class SnappyLoader {
    public static final String SNAPPY_SYSTEM_PROPERTIES_FILE = "org-xerial-snappy.properties";
    public static final String KEY_SNAPPY_LIB_PATH = "org.xerial.snappy.lib.path";
    public static final String KEY_SNAPPY_LIB_NAME = "org.xerial.snappy.lib.name";
    public static final String KEY_SNAPPY_TEMPDIR = "org.xerial.snappy.tempdir";
    public static final String KEY_SNAPPY_USE_SYSTEMLIB = "org.xerial.snappy.use.systemlib";
    public static final String KEY_SNAPPY_DISABLE_BUNDLED_LIBS = "org.xerial.snappy.disable.bundled.libs";
    private static volatile boolean isLoaded = false;
    private static volatile SnappyNative api = null;
    private static File nativeLibFile = null;

    static void cleanUpExtractedNativeLib() {
        if (nativeLibFile != null && nativeLibFile.exists()) {
            nativeLibFile.delete();
        }
    }

    static synchronized void setApi(SnappyNative snappyNative) {
        api = snappyNative;
    }

    private static void loadSnappySystemProperties() {
        try {
            InputStream inputStream = Thread.currentThread().getContextClassLoader().getResourceAsStream(SNAPPY_SYSTEM_PROPERTIES_FILE);
            if (inputStream == null) {
                return;
            }
            Properties properties = new Properties();
            properties.load(inputStream);
            inputStream.close();
            Enumeration<?> enumeration = properties.propertyNames();
            while (enumeration.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                if (!string.startsWith("org.xerial.snappy.") || System.getProperty(string) != null) continue;
                System.setProperty(string, properties.getProperty(string));
            }
        }
        catch (Throwable throwable) {
            System.err.println("Could not load 'org-xerial-snappy.properties' from classpath: " + throwable.toString());
        }
    }

    static synchronized SnappyNative load() {
        if (api != null) {
            return api;
        }
        try {
            SnappyLoader.loadNativeLibrary();
            SnappyLoader.setApi(new SnappyNative());
            isLoaded = true;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new SnappyError(SnappyErrorCode.FAILED_TO_LOAD_NATIVE_LIBRARY, exception.getMessage());
        }
        return api;
    }

    private static void loadNativeLibrary() {
        nativeLibFile = SnappyLoader.findNativeLibrary();
        if (nativeLibFile != null) {
            System.load(nativeLibFile.getAbsolutePath());
        } else {
            System.loadLibrary("snappyjava");
        }
    }

    private static boolean contentsEquals(InputStream inputStream, InputStream inputStream2) throws IOException {
        int n;
        if (!(inputStream instanceof BufferedInputStream)) {
            inputStream = new BufferedInputStream(inputStream);
        }
        if (!(inputStream2 instanceof BufferedInputStream)) {
            inputStream2 = new BufferedInputStream(inputStream2);
        }
        int n2 = inputStream.read();
        while (n2 != -1) {
            n = inputStream2.read();
            if (n2 != n) {
                return false;
            }
            n2 = inputStream.read();
        }
        n = inputStream2.read();
        return n == -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static File extractLibraryFile(String string, String string2, String string3) {
        String string4 = string + "/" + string2;
        String string5 = UUID.randomUUID().toString();
        String string6 = String.format("snappy-%s-%s-%s", SnappyLoader.getVersion(), string5, string2);
        File file = new File(string3, string6);
        try {
            Object object;
            InputStream inputStream = SnappyLoader.class.getResourceAsStream(string4);
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            try {
                object = new byte[8192];
                int n = 0;
                while ((n = inputStream.read((byte[])object)) != -1) {
                    fileOutputStream.write((byte[])object, 0, n);
                }
            }
            finally {
                file.deleteOnExit();
                if (fileOutputStream != null) {
                    fileOutputStream.close();
                }
                if (inputStream != null) {
                    inputStream.close();
                }
            }
            file.setReadable(true);
            file.setWritable(true, true);
            file.setExecutable(true);
            object = SnappyLoader.class.getResourceAsStream(string4);
            FileInputStream fileInputStream = new FileInputStream(file);
            try {
                if (!SnappyLoader.contentsEquals((InputStream)object, fileInputStream)) {
                    throw new SnappyError(SnappyErrorCode.FAILED_TO_LOAD_NATIVE_LIBRARY, String.format("Failed to write a native library file at %s", file));
                }
            }
            finally {
                if (object != null) {
                    ((InputStream)object).close();
                }
                if (fileInputStream != null) {
                    ((InputStream)fileInputStream).close();
                }
            }
            return new File(string3, string6);
        }
        catch (IOException iOException) {
            iOException.printStackTrace(System.err);
            return null;
        }
    }

    static File findNativeLibrary() {
        String string;
        File file;
        boolean bl = Boolean.parseBoolean(System.getProperty(KEY_SNAPPY_USE_SYSTEMLIB, "false"));
        boolean bl2 = Boolean.parseBoolean(System.getProperty(KEY_SNAPPY_DISABLE_BUNDLED_LIBS, "false"));
        if (bl || bl2) {
            return null;
        }
        String string2 = System.getProperty(KEY_SNAPPY_LIB_PATH);
        String string3 = System.getProperty(KEY_SNAPPY_LIB_NAME);
        if (string3 == null) {
            string3 = System.mapLibraryName("snappyjava");
        }
        if (string2 != null && (file = new File(string2, string3)).exists()) {
            return file;
        }
        string2 = "/org/xerial/snappy/native/" + OSInfo.getNativeLibFolderPathForCurrentOS();
        boolean bl3 = SnappyLoader.hasResource(string2 + "/" + string3);
        if (!bl3 && OSInfo.getOSName().equals("Mac")) {
            string = "libsnappyjava.jnilib";
            if (SnappyLoader.hasResource(string2 + "/" + string)) {
                string3 = string;
                bl3 = true;
            }
        }
        if (!bl3) {
            string = String.format("no native library is found for os.name=%s and os.arch=%s", OSInfo.getOSName(), OSInfo.getArchName());
            throw new SnappyError(SnappyErrorCode.FAILED_TO_LOAD_NATIVE_LIBRARY, string);
        }
        string = new File(System.getProperty(KEY_SNAPPY_TEMPDIR, System.getProperty("java.io.tmpdir"))).getAbsolutePath();
        return SnappyLoader.extractLibraryFile(string2, string3, string);
    }

    private static boolean hasResource(String string) {
        return SnappyLoader.class.getResource(string) != null;
    }

    public static String getVersion() {
        URL uRL = SnappyLoader.class.getResource("/META-INF/maven/org.xerial.snappy/snappy-java/pom.properties");
        if (uRL == null) {
            uRL = SnappyLoader.class.getResource("/org/xerial/snappy/VERSION");
        }
        String string = "unknown";
        try {
            if (uRL != null) {
                Properties properties = new Properties();
                properties.load(uRL.openStream());
                string = properties.getProperty("version", string);
                if (string.equals("unknown")) {
                    string = properties.getProperty("VERSION", string);
                }
                string = string.trim().replaceAll("[^0-9M\\.]", "");
            }
        }
        catch (IOException iOException) {
            System.err.println(iOException);
        }
        return string;
    }

    static {
        SnappyLoader.loadSnappySystemProperties();
    }
}

