/*
 * Decompiled with CFR 0.152.
 */
package edu.uiuc.ncsa.security.oauth_1_0a;

import edu.uiuc.ncsa.security.core.Identifier;
import edu.uiuc.ncsa.security.core.exceptions.GeneralException;
import edu.uiuc.ncsa.security.core.util.IdentifierProvider;
import edu.uiuc.ncsa.security.delegation.server.MissingTokenException;
import edu.uiuc.ncsa.security.delegation.token.AccessToken;
import edu.uiuc.ncsa.security.delegation.token.AuthorizationGrant;
import edu.uiuc.ncsa.security.delegation.token.TokenForge;
import edu.uiuc.ncsa.security.delegation.token.Verifier;
import edu.uiuc.ncsa.security.delegation.token.impl.AccessTokenImpl;
import edu.uiuc.ncsa.security.delegation.token.impl.AuthorizationGrantImpl;
import edu.uiuc.ncsa.security.delegation.token.impl.VerifierImpl;
import edu.uiuc.ncsa.security.oauth_1_0a.OAuthUtilities;
import java.net.URI;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;

public class OAuthTokenForge
implements TokenForge {
    String server;
    public String tempCred = "tempCred";
    public String tempCredSS = "tempCred/sharedSecret";
    public String accessToken = "accessToken";
    public String accessTokenSS = "accessToken/sharedSecret";
    public String verifier = "verifier";
    IdentifierProvider<Identifier> atIdProvider;
    IdentifierProvider<Identifier> atssIdProvider;
    IdentifierProvider<Identifier> agIdProvider;
    IdentifierProvider<Identifier> agssIdProvider;
    IdentifierProvider<Identifier> verifierIdProvider;

    public OAuthTokenForge(String server) {
        this.server = server;
        this.setup();
    }

    protected void setup() {
        if (this.server == null) {
            return;
        }
        URI serverUri = URI.create(this.server);
        this.atIdProvider = new IdentifierProvider<Identifier>(serverUri, this.accessToken(new String[0]), true){};
        this.atssIdProvider = new IdentifierProvider<Identifier>(serverUri, this.accessTokenSS(new String[0]), true){};
        this.agIdProvider = new IdentifierProvider<Identifier>(serverUri, this.tempCred(new String[0]), true){};
        this.agssIdProvider = new IdentifierProvider<Identifier>(serverUri, this.tempCredSS(new String[0]), true){};
        this.verifierIdProvider = new IdentifierProvider<Identifier>(serverUri, this.verifier(new String[0]), true){};
    }

    protected String tempCred(String ... x) {
        if (1 == x.length) {
            this.tempCred = x[0];
        }
        return this.tempCred;
    }

    protected String tempCredSS(String ... x) {
        if (1 == x.length) {
            this.tempCredSS = x[0];
        }
        return this.tempCredSS;
    }

    protected String accessToken(String ... x) {
        if (1 == x.length) {
            this.accessToken = x[0];
        }
        return this.accessToken;
    }

    protected String accessTokenSS(String ... x) {
        if (1 == x.length) {
            this.accessTokenSS = x[0];
        }
        return this.accessTokenSS;
    }

    protected String verifier(String ... x) {
        if (1 == x.length) {
            this.verifier = x[0];
        }
        return this.verifier;
    }

    public AccessToken getAccessToken(Map<String, String> parameters) {
        String token = parameters.get("oauth_token");
        if (token == null) {
            throw new MissingTokenException("Error: the access token is missing.");
        }
        String secret = parameters.get("oauth_token_secret");
        return this.getAccessToken(token, secret);
    }

    public AuthorizationGrant getAuthorizationGrant(Map<String, String> parameters) {
        String token = parameters.get("oauth_token");
        if (token == null) {
            return null;
        }
        String secret = parameters.get("oauth_token_secret");
        return this.getAuthorizationGrant(token, secret);
    }

    public AuthorizationGrant getAuthorizationGrant(HttpServletRequest request) {
        try {
            return this.getAuthorizationGrant(OAuthUtilities.getParameters(request));
        }
        catch (Exception e) {
            throw new GeneralException("Error: could not create the authorization grant", (Throwable)e);
        }
    }

    public AuthorizationGrant getAuthorizationGrant(String ... tokens) {
        switch (tokens.length) {
            case 0: {
                return new AuthorizationGrantImpl(this.agIdProvider.get().getUri(), this.agssIdProvider.get().getUri());
            }
            case 1: {
                return new AuthorizationGrantImpl(tokens[0] == null ? null : URI.create(tokens[0]));
            }
        }
        return new AuthorizationGrantImpl(tokens[0] == null ? null : URI.create(tokens[0]), tokens[1] == null ? null : URI.create(tokens[1]));
    }

    public AccessToken getAccessToken(HttpServletRequest request) {
        try {
            return this.getAccessToken(OAuthUtilities.getParameters(request));
        }
        catch (Exception e) {
            throw new GeneralException("Could not create a token", (Throwable)e);
        }
    }

    public AccessToken getAccessToken(String ... tokens) {
        switch (tokens.length) {
            case 0: {
                return new AccessTokenImpl(this.atIdProvider.get().getUri(), this.atssIdProvider.get().getUri());
            }
            case 1: {
                return new AccessTokenImpl(tokens[0] == null ? null : URI.create(tokens[0]));
            }
        }
        return new AccessTokenImpl(tokens[0] == null ? null : URI.create(tokens[0]), tokens[1] == null ? null : URI.create(tokens[1]));
    }

    public Verifier getVerifier(Map<String, String> parameters) {
        String verifier = parameters.get("oauth_verifier");
        if (verifier == null) {
            throw new MissingTokenException("Error: missing verifier");
        }
        return this.getVerifier(verifier);
    }

    public Verifier getVerifier(HttpServletRequest request) {
        try {
            return this.getVerifier(OAuthUtilities.getParameters(request));
        }
        catch (Exception e) {
            throw new GeneralException("Error: Could not create verifier", (Throwable)e);
        }
    }

    public Verifier getVerifier(String ... tokens) {
        switch (tokens.length) {
            case 0: {
                return new VerifierImpl(this.verifierIdProvider.get().getUri());
            }
            case 1: {
                return new VerifierImpl(tokens[0] == null ? null : URI.create(tokens[0]));
            }
        }
        throw new IllegalArgumentException("Error: verifiers do not require multiple arguments");
    }
}

