/*
 * Decompiled with CFR 0.152.
 */
package eu.unicore.security.wsutil.client;

import eu.emi.security.authn.x509.X509Credential;
import eu.unicore.security.wsutil.DSigDecider;
import eu.unicore.security.wsutil.client.DSigOutHandler;
import eu.unicore.security.wsutil.client.OnDemandSAAJOutInterceptor;
import eu.unicore.security.wsutil.client.ToBeSignedDecider;
import java.util.List;
import org.apache.cxf.endpoint.Client;
import org.apache.cxf.frontend.ClientProxy;

public class ClientDSigUtil {
    public static void addDSigHandler(Object xfireProxy, X509Credential securityCfg, DSigDecider decider, ToBeSignedDecider partsDecider) {
        Client xfireClient = ClientProxy.getClient((Object)xfireProxy);
        ClientDSigUtil.addDSigHandler(xfireClient, securityCfg, decider, partsDecider);
    }

    public static void addDSigHandler(Client xfireClient, X509Credential securityCfg, DSigDecider decider, ToBeSignedDecider partsDecider) {
        List outHandlers = xfireClient.getOutInterceptors();
        for (Object h : outHandlers) {
            if (!(h instanceof DSigOutHandler)) continue;
            outHandlers.remove(h);
            break;
        }
        for (Object h : outHandlers) {
            if (!(h instanceof OnDemandSAAJOutInterceptor)) continue;
            outHandlers.remove(h);
            break;
        }
        xfireClient.getOutInterceptors().add(new OnDemandSAAJOutInterceptor(decider));
        xfireClient.getOutInterceptors().add(new DSigOutHandler(securityCfg, decider, partsDecider));
    }

    public static void removeDSigHandlers(Object xfireProxy) {
        Client xfireClient = ClientProxy.getClient((Object)xfireProxy);
        ClientDSigUtil.removeDSigHandlers(xfireClient);
    }

    public static void removeDSigHandlers(Client xfireClient) {
        List outHandlers = xfireClient.getOutInterceptors();
        for (int i = outHandlers.size() - 1; i >= 0; --i) {
            Object h = outHandlers.get(i);
            if (!(h instanceof DSigOutHandler) && !(h instanceof OnDemandSAAJOutInterceptor)) continue;
            outHandlers.remove(i);
        }
    }
}

