/*
 * Decompiled with CFR 0.152.
 */
package eu.unicore.samly2.proto;

import eu.unicore.samly2.SAMLConstants;
import eu.unicore.samly2.exceptions.SAMLServerException;
import eu.unicore.samly2.proto.AbstractSAMLMessage;
import java.util.Calendar;
import org.apache.xmlbeans.XmlObject;
import xmlbeans.org.oasis.saml2.assertion.NameIDType;
import xmlbeans.org.oasis.saml2.protocol.StatusCodeType;
import xmlbeans.org.oasis.saml2.protocol.StatusResponseType;
import xmlbeans.org.oasis.saml2.protocol.StatusType;

public abstract class AbstractStatusResponse<T extends XmlObject, C extends StatusResponseType>
extends AbstractSAMLMessage<T> {
    protected C xmlResp;

    protected void init(T srcDoc, C src, NameIDType issuer, String inResponseTo) {
        this.xmlDocuemnt = srcDoc;
        this.xmlResp = src;
        this.xmlResp.setIssuer(issuer);
        this.xmlResp.setIssueInstant(Calendar.getInstance());
        this.xmlResp.setID(this.genID());
        this.xmlResp.setVersion("2.0");
        if (inResponseTo != null) {
            this.xmlResp.setInResponseTo(inResponseTo);
        }
    }

    public C getXMLBean() {
        return this.xmlResp;
    }

    public static StatusType createOKStatus() {
        StatusType ok = StatusType.Factory.newInstance();
        StatusCodeType okCode = ok.addNewStatusCode();
        okCode.setValue(SAMLConstants.Status.STATUS_OK.toString());
        return ok;
    }

    public static StatusType createErrorStatus(SAMLServerException e) {
        StatusType error = StatusType.Factory.newInstance();
        StatusCodeType errorCode = error.addNewStatusCode();
        errorCode.setValue(e.getSamlErrorId().toString());
        if (e.getSamlSubErrorId() != null) {
            errorCode.addNewStatusCode().setValue(e.getSamlSubErrorId().toString());
        }
        if (e.getMessage() != null) {
            error.setStatusMessage(e.getMessage());
        }
        return error;
    }
}

