/*
 * Decompiled with CFR 0.152.
 */
package eu.unicore.samly2.attrprofile;

import eu.unicore.samly2.SAMLConstants;
import eu.unicore.samly2.attrprofile.ParsedAttribute;
import eu.unicore.samly2.attrprofile.SAMLAttributeProfile;
import eu.unicore.samly2.elements.SAMLAttribute;
import eu.unicore.samly2.exceptions.SAMLValidationException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.xmlbeans.XmlCursor;
import org.apache.xmlbeans.XmlObject;
import org.apache.xmlbeans.XmlString;
import xmlbeans.org.oasis.saml2.assertion.AttributeType;
import xmlbeans.pl.edu.icm.samlvo.attrext.ScopedStringAttributeValueType;

public class UVOSAttributeProfile
implements SAMLAttributeProfile {
    @Override
    public int isSupported(ParsedAttribute attr) {
        if (attr.getDataType().isAssignableFrom(ScopedStringValue.class)) {
            return 100;
        }
        return -1;
    }

    @Override
    public int isSupported(AttributeType xmlAttr) {
        XmlCursor cur = xmlAttr.newCursor();
        String scopingType = cur.getAttributeText(SAMLConstants.SCOPE_TYPE_XMLATTRIBUTE);
        String scope = cur.getAttributeText(SAMLConstants.ATTRIBUTE_SCOPE_XMLATTRIBUTE);
        cur.dispose();
        if (scopingType != null || scope != null) {
            return 100;
        }
        return -1;
    }

    @Override
    public ParsedAttribute map(AttributeType xmlAttr) throws SAMLValidationException {
        ParsedAttribute ret = new ParsedAttribute(xmlAttr.getName());
        ret.setDataType(ScopedStringValue.class);
        String shortDesc = xmlAttr.getFriendlyName();
        ret.setDescription(shortDesc);
        ArrayList<ScopedStringValue> values = new ArrayList<ScopedStringValue>();
        ArrayList<String> stringValues = new ArrayList<String>();
        ret.setValues(stringValues, values);
        XmlObject[] xmlVals = xmlAttr.getAttributeValueArray();
        XmlCursor cur = xmlAttr.newCursor();
        String xacmlDT = cur.getAttributeText(SAMLConstants.XACMLDT);
        String scopingType = cur.getAttributeText(SAMLConstants.SCOPE_TYPE_XMLATTRIBUTE);
        String attributeScope = cur.getAttributeText(SAMLConstants.ATTRIBUTE_SCOPE_XMLATTRIBUTE);
        cur.dispose();
        if (xmlVals == null || xmlVals.length == 0) {
            values.add(new ScopedStringValue(attributeScope, xacmlDT, null));
            stringValues.add(null);
            return ret;
        }
        for (int i = 0; i < xmlVals.length; ++i) {
            ScopedStringValue tmp = this.mapAttrValue2APIValue(xmlVals[i], xacmlDT, scopingType);
            values.add(tmp);
            stringValues.add(tmp.getValue());
        }
        return ret;
    }

    private ScopedStringValue mapAttrValue2APIValue(XmlObject value, String xacmlType, String scopingType) throws SAMLValidationException {
        String scope = null;
        String svalue = null;
        if (scopingType == null) {
            scopingType = "urn:SAML:voprofile:NonScopedValue";
        }
        if (value instanceof XmlString && scopingType.equals("urn:SAML:voprofile:NonScopedValue")) {
            svalue = ((XmlString)value).getStringValue();
        } else if (value instanceof ScopedStringAttributeValueType && scopingType.equals("urn:SAML:voprofile:ScopedValue")) {
            ScopedStringAttributeValueType av = (ScopedStringAttributeValueType)value;
            scope = av.getScope();
            if (scope.equals("/")) {
                scope = null;
            }
            String v = av.getStringValue();
            if (!av.isNil()) {
                svalue = v;
            }
        } else if (value instanceof XmlString && scopingType.equals("urn:SAML:voprofile:SimpleScopedString")) {
            String content = ((XmlString)value).getStringValue();
            if (content == null || !content.contains("@/")) {
                throw new SAMLValidationException("Content of SimpleScopedString attribute value is invalid");
            }
            int sep = content.lastIndexOf("@");
            scope = sep + 2 < content.length() ? content.substring(sep + 1) : null;
            String v = content.substring(0, sep);
            if (!v.equals("")) {
                svalue = v;
            }
        } else {
            throw new SAMLValidationException("Unknown type of attribute value received for UVOSSAMLProfile, likely it's a BUG, value " + value.xmlText());
        }
        return new ScopedStringValue(scope, xacmlType, svalue);
    }

    @Override
    public AttributeType map(ParsedAttribute attr) throws SAMLValidationException {
        SAMLAttribute helper = new SAMLAttribute(attr.getName(), null, attr.getDescription());
        helper.setScopingType("urn:SAML:voprofile:ScopedValue");
        for (Object v : attr.getObjectValues()) {
            ScopedStringValue sv = (ScopedStringValue)v;
            helper.addScopedStringAttributeValue(sv.getValue(), sv.getScope());
            helper.setXACMLDataType(sv.getXacmlType());
        }
        return helper.getXBean();
    }

    public static List<ParsedAttribute> splitByScopes(List<ParsedAttribute> from) {
        ArrayList<ParsedAttribute> ret = new ArrayList<ParsedAttribute>(from.size() * 3);
        for (int i = from.size() - 1; i >= 0; --i) {
            ParsedAttribute a = from.get(i);
            if (a.getDataType().isAssignableFrom(ScopedStringValue.class)) {
                List<ParsedAttribute> byScope = UVOSAttributeProfile.splitByScopes(a);
                ret.addAll(byScope);
                continue;
            }
            ret.add(a);
        }
        return ret;
    }

    private static List<ParsedAttribute> splitByScopes(ParsedAttribute pa) {
        HashMap<String, ArrayList<ScopedStringValue>> valuesByScope = new HashMap<String, ArrayList<ScopedStringValue>>();
        for (int j = 0; j < pa.getObjectValues().size(); ++j) {
            ScopedStringValue value = (ScopedStringValue)pa.getObjectValues().get(j);
            String scope = value.getScope();
            ArrayList<ScopedStringValue> values = (ArrayList<ScopedStringValue>)valuesByScope.get(scope);
            if (values == null) {
                values = new ArrayList<ScopedStringValue>();
                valuesByScope.put(scope, values);
            }
            values.add(value);
        }
        ArrayList<ParsedAttribute> ret = new ArrayList<ParsedAttribute>(valuesByScope.keySet().size());
        for (Map.Entry entry : valuesByScope.entrySet()) {
            ParsedAttribute a = new ParsedAttribute(pa.getName());
            a.setDataType(a.getDataType());
            a.setDescription(a.getDescription());
            ArrayList<String> valsAsString = new ArrayList<String>(((List)entry.getValue()).size());
            for (ScopedStringValue hl : (List)entry.getValue()) {
                valsAsString.add(hl.getValue());
            }
            a.setValues(valsAsString, (List)entry.getValue());
            ret.add(a);
        }
        return ret;
    }

    public static class ScopedStringValue
    implements Serializable {
        private String scope;
        private String xacmlType;
        private String value;

        public ScopedStringValue(String scope, String xacmlType, String value) {
            this.scope = scope;
            this.xacmlType = xacmlType;
            this.value = value;
        }

        public String getScope() {
            return this.scope;
        }

        public String getValue() {
            return this.value;
        }

        public String getXacmlType() {
            return this.xacmlType;
        }
    }
}

