/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.bus.osgi;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.logging.Logger;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.configuration.ConfiguredBeanLocator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;

public class OSGiBeanLocator
implements ConfiguredBeanLocator {
    private static final Logger LOG = LogUtils.getL7dLogger(OSGiBeanLocator.class);
    final ConfiguredBeanLocator cbl;
    final BundleContext context;

    public OSGiBeanLocator(ConfiguredBeanLocator c, BundleContext ctx) {
        this.cbl = c;
        this.context = ctx;
    }

    public <T> T getBeanOfType(String name, Class<T> type) {
        return (T)this.cbl.getBeanOfType(name, type);
    }

    public <T> Collection<? extends T> getBeansOfType(Class<T> type) {
        Collection ret = this.cbl.getBeansOfType(type);
        if (ret == null || ret.isEmpty()) {
            return this.getBeansFromOsgiService(type);
        }
        return ret;
    }

    private <T> List<T> getBeansFromOsgiService(Class<T> type) {
        ArrayList<T> list = new ArrayList<T>();
        try {
            ServiceReference[] refs = this.context.getServiceReferences(type.getName(), null);
            if (refs != null) {
                for (ServiceReference r : refs) {
                    list.add(type.cast(this.context.getService(r)));
                }
            }
        }
        catch (Exception ex) {
            LOG.info("Tried to find the Bean with type:" + type + " from OSGi services and get error: " + ex);
        }
        return list;
    }

    public <T> boolean loadBeansOfType(Class<T> type, ConfiguredBeanLocator.BeanLoaderListener<T> listener) {
        return this.cbl.loadBeansOfType(type, listener);
    }

    public boolean hasConfiguredPropertyValue(String beanName, String propertyName, String value) {
        return this.cbl.hasConfiguredPropertyValue(beanName, propertyName, value);
    }

    public List<String> getBeanNamesOfType(Class<?> type) {
        return this.cbl.getBeanNamesOfType(type);
    }

    public boolean hasBeanOfName(String name) {
        return this.cbl.hasBeanOfName(name);
    }
}

