/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.rds.model;

import com.amazonaws.internal.ListWithAutoConstructFlag;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class Filter
implements Serializable {
    private String filterName;
    private ListWithAutoConstructFlag<String> filterValue;

    public String getFilterName() {
        return this.filterName;
    }

    public void setFilterName(String filterName) {
        this.filterName = filterName;
    }

    public Filter withFilterName(String filterName) {
        this.filterName = filterName;
        return this;
    }

    public List<String> getFilterValue() {
        if (this.filterValue == null) {
            this.filterValue = new ListWithAutoConstructFlag();
            this.filterValue.setAutoConstruct(true);
        }
        return this.filterValue;
    }

    public void setFilterValue(Collection<String> filterValue) {
        if (filterValue == null) {
            this.filterValue = null;
            return;
        }
        ListWithAutoConstructFlag filterValueCopy = new ListWithAutoConstructFlag(filterValue.size());
        filterValueCopy.addAll(filterValue);
        this.filterValue = filterValueCopy;
    }

    public Filter withFilterValue(String ... filterValue) {
        if (this.getFilterValue() == null) {
            this.setFilterValue(new ArrayList<String>(filterValue.length));
        }
        for (String value : filterValue) {
            this.getFilterValue().add(value);
        }
        return this;
    }

    public Filter withFilterValue(Collection<String> filterValue) {
        if (filterValue == null) {
            this.filterValue = null;
        } else {
            ListWithAutoConstructFlag filterValueCopy = new ListWithAutoConstructFlag(filterValue.size());
            filterValueCopy.addAll(filterValue);
            this.filterValue = filterValueCopy;
        }
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getFilterName() != null) {
            sb.append("FilterName: " + this.getFilterName() + ",");
        }
        if (this.getFilterValue() != null) {
            sb.append("FilterValue: " + this.getFilterValue());
        }
        sb.append("}");
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getFilterName() == null ? 0 : this.getFilterName().hashCode());
        hashCode = 31 * hashCode + (this.getFilterValue() == null ? 0 : this.getFilterValue().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Filter)) {
            return false;
        }
        Filter other = (Filter)obj;
        if (other.getFilterName() == null ^ this.getFilterName() == null) {
            return false;
        }
        if (other.getFilterName() != null && !other.getFilterName().equals(this.getFilterName())) {
            return false;
        }
        if (other.getFilterValue() == null ^ this.getFilterValue() == null) {
            return false;
        }
        return other.getFilterValue() == null || other.getFilterValue().equals(this.getFilterValue());
    }
}

