/*
 * Decompiled with CFR 0.152.
 */
package org.apache.airavata.service.profile.user.core.repositories;

import java.util.HashMap;
import java.util.List;
import org.apache.airavata.model.user.UserProfile;
import org.apache.airavata.service.profile.commons.repositories.AbstractRepository;
import org.apache.airavata.service.profile.commons.user.entities.UserProfileEntity;
import org.apache.airavata.service.profile.commons.utils.JPAUtils;
import org.apache.airavata.service.profile.commons.utils.ObjectMapperSingleton;
import org.apache.airavata.service.profile.commons.utils.QueryConstants;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UserProfileRepository
extends AbstractRepository<UserProfile, UserProfileEntity, String> {
    private static final Logger logger = LoggerFactory.getLogger(UserProfileRepository.class);

    public UserProfileRepository(Class<UserProfile> thriftGenericClass, Class<UserProfileEntity> dbEntityGenericClass) {
        super(thriftGenericClass, dbEntityGenericClass);
    }

    public List<UserProfile> select(String query, int offset, int limit) {
        throw new UnsupportedOperationException("Due to performance overheads this method is not supported. Instead use UserProfileSummaryRepository");
    }

    public UserProfile getUserProfileByIdAndGateWay(String userId, String gatewayId) {
        UserProfile userProfile = null;
        HashMap<String, String> queryParam = new HashMap<String, String>();
        queryParam.put(UserProfile._Fields.USER_ID.getFieldName(), userId);
        queryParam.put(UserProfile._Fields.GATEWAY_ID.getFieldName(), gatewayId);
        List resultList = this.select(QueryConstants.FIND_USER_PROFILE_BY_USER_ID, 1, 0, queryParam);
        if (resultList != null && resultList.size() > 0) {
            userProfile = (UserProfile)resultList.get(0);
        }
        return userProfile;
    }

    public List<UserProfile> getAllUserProfilesInGateway(String gatewayId, int offset, int limit) {
        HashMap<String, String> queryParam = new HashMap<String, String>();
        queryParam.put(UserProfile._Fields.GATEWAY_ID.getFieldName(), gatewayId);
        List resultList = this.select(QueryConstants.FIND_ALL_USER_PROFILES_BY_GATEWAY_ID, limit, offset, queryParam);
        return resultList;
    }

    public UserProfile create(UserProfile userProfile) {
        throw new UnsupportedOperationException("Please use createUserProfile instead");
    }

    public UserProfile update(UserProfile userProfile) {
        throw new UnsupportedOperationException("Please use updateUserProfile instead");
    }

    public UserProfile createUserProfile(UserProfile userProfile, Runnable postUpdateAction) {
        return this.updateUserProfile(userProfile, postUpdateAction);
    }

    public UserProfile updateUserProfile(UserProfile userProfile, Runnable postUpdateAction) {
        ObjectMapperSingleton mapper = ObjectMapperSingleton.getInstance();
        UserProfileEntity entity = (UserProfileEntity)mapper.map((Object)userProfile, UserProfileEntity.class);
        UserProfileEntity persistedCopy = (UserProfileEntity)JPAUtils.execute(entityManager -> {
            UserProfileEntity result = (UserProfileEntity)entityManager.merge((Object)entity);
            postUpdateAction.run();
            return result;
        });
        return (UserProfile)mapper.map((Object)persistedCopy, UserProfile.class);
    }
}

