/*
 * Decompiled with CFR 0.152.
 */
package org.apache.airavata.credential.store.notifier.impl;

import javax.mail.Authenticator;
import org.apache.airavata.credential.store.notifier.CredentialStoreNotifier;
import org.apache.airavata.credential.store.notifier.NotificationMessage;
import org.apache.airavata.credential.store.notifier.impl.EmailNotificationMessage;
import org.apache.airavata.credential.store.notifier.impl.EmailNotifierConfiguration;
import org.apache.airavata.credential.store.store.CredentialStoreException;
import org.apache.commons.mail.DefaultAuthenticator;
import org.apache.commons.mail.EmailException;
import org.apache.commons.mail.SimpleEmail;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EmailNotifier
implements CredentialStoreNotifier {
    protected static Logger log = LoggerFactory.getLogger(EmailNotifier.class);
    private EmailNotifierConfiguration emailNotifierConfiguration;

    public EmailNotifier(EmailNotifierConfiguration notifierConfiguration) {
        this.emailNotifierConfiguration = notifierConfiguration;
    }

    @Override
    public void notifyMessage(NotificationMessage message) throws CredentialStoreException {
        try {
            SimpleEmail email = new SimpleEmail();
            email.setHostName(this.emailNotifierConfiguration.getEmailServer());
            email.setSmtpPort(this.emailNotifierConfiguration.getEmailServerPort());
            email.setAuthenticator((Authenticator)new DefaultAuthenticator(this.emailNotifierConfiguration.getEmailUserName(), this.emailNotifierConfiguration.getEmailPassword()));
            email.setSSLOnConnect(this.emailNotifierConfiguration.isSslConnect());
            email.setFrom(this.emailNotifierConfiguration.getFromAddress());
            EmailNotificationMessage emailMessage = (EmailNotificationMessage)message;
            email.setSubject(emailMessage.getSubject());
            email.setMsg(emailMessage.getMessage());
            email.addTo(emailMessage.getSenderEmail());
            email.send();
        }
        catch (EmailException e) {
            log.error("[CredentialStore]Error sending email notification message.");
            throw new CredentialStoreException("Error sending email notification message", e);
        }
    }
}

