/*
 * Decompiled with CFR 0.152.
 */
package org.apache.airavata.credential.store.credential.impl.ssh;

import com.jcraft.jsch.JSch;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.KeyPair;
import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.apache.airavata.credential.store.credential.impl.ssh.SSHCredential;
import org.apache.airavata.credential.store.store.CredentialStoreException;
import org.apache.airavata.credential.store.store.impl.SSHCredentialWriter;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.RandomStringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SSHCredentialGenerator {
    private static Logger logger = LoggerFactory.getLogger(SSHCredentialWriter.class);

    public SSHCredential generateCredential(String tokenId) throws CredentialStoreException {
        JSch jsch = new JSch();
        try {
            KeyPair kpair = KeyPair.genKeyPair((JSch)jsch, (int)2);
            File file = File.createTempFile("id_rsa", "");
            String fileName = file.getAbsolutePath();
            String password = this.generateRandomString();
            kpair.writePrivateKey(fileName, password.getBytes());
            kpair.writePublicKey(fileName + ".pub", "");
            kpair.dispose();
            byte[] priKey = FileUtils.readFileToByteArray((File)new File(fileName));
            byte[] pubKey = FileUtils.readFileToByteArray((File)new File(fileName + ".pub"));
            SSHCredential sshCredential = new SSHCredential();
            sshCredential.setPrivateKey(priKey);
            sshCredential.setPublicKey(pubKey);
            sshCredential.setPassphrase(password);
            return sshCredential;
        }
        catch (IOException e) {
            logger.error("IO Exception when creating SSH credential ", (Throwable)e);
            throw new CredentialStoreException("Unable to generate SSH Credential", e);
        }
        catch (JSchException e) {
            logger.error("JSch SSH credential creation exception ", (Throwable)e);
            throw new CredentialStoreException("Unable to generate SSH Credential. JSch exception ", e);
        }
    }

    private String generateHash(String tokenId, String password) {
        byte[] bytesOfMessage = new byte[]{};
        try {
            bytesOfMessage = password.getBytes("UTF-8");
            MessageDigest md = MessageDigest.getInstance("MD5");
            return new String(md.digest(bytesOfMessage));
        }
        catch (UnsupportedEncodingException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        catch (NoSuchAlgorithmException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        return null;
    }

    private String generateRandomString() {
        return RandomStringUtils.randomAlphanumeric((int)16);
    }
}

