/*
 * Decompiled with CFR 0.152.
 */
package org.apache.airavata.registry.core.app.catalog.resources;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import org.apache.airavata.common.exception.ApplicationSettingsException;
import org.apache.airavata.registry.core.app.catalog.model.ComputeResource;
import org.apache.airavata.registry.core.app.catalog.model.ComputeResourceFileSystem;
import org.apache.airavata.registry.core.app.catalog.model.ComputeResourceFileSystem_PK;
import org.apache.airavata.registry.core.app.catalog.resources.AppCatAbstractResource;
import org.apache.airavata.registry.core.app.catalog.resources.AppCatalogResource;
import org.apache.airavata.registry.core.app.catalog.resources.ComputeResourceResource;
import org.apache.airavata.registry.core.app.catalog.util.AppCatalogJPAUtils;
import org.apache.airavata.registry.core.app.catalog.util.AppCatalogQueryGenerator;
import org.apache.airavata.registry.core.app.catalog.util.AppCatalogResourceType;
import org.apache.airavata.registry.cpi.AppCatalogException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ComputeResourceFileSystemResource
extends AppCatAbstractResource {
    private static final Logger logger = LoggerFactory.getLogger(ComputeResourceFileSystemResource.class);
    private String computeResourceId;
    private ComputeResourceResource computeHostResource;
    private String path;
    private String fileSystem;

    @Override
    public void remove(Object identifier) throws AppCatalogException {
        if (!(identifier instanceof Map)) {
            logger.error("Identifier should be a map with the field name and it's value");
            throw new AppCatalogException("Identifier should be a map with the field name and it's value");
        }
        HashMap ids = (HashMap)identifier;
        EntityManager em = null;
        try {
            em = AppCatalogJPAUtils.getEntityManager();
            em.getTransaction().begin();
            AppCatalogQueryGenerator generator = new AppCatalogQueryGenerator("ComputeResourceFileSystem", new Object[0][]);
            generator.setParameter("computeResourceId", ids.get("computeResourceId"));
            generator.setParameter("fileSystem", ids.get("fileSystem"));
            Query q = generator.deleteQuery(em);
            q.executeUpdate();
            em.getTransaction().commit();
            if (em.isOpen()) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                em.close();
            }
        }
        catch (ApplicationSettingsException e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new AppCatalogException((Throwable)e);
        }
        finally {
            if (em != null && em.isOpen()) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                em.close();
            }
        }
    }

    @Override
    public AppCatalogResource get(Object identifier) throws AppCatalogException {
        if (!(identifier instanceof Map)) {
            logger.error("Identifier should be a map with the field name and it's value");
            throw new AppCatalogException("Identifier should be a map with the field name and it's value");
        }
        HashMap ids = (HashMap)identifier;
        EntityManager em = null;
        try {
            em = AppCatalogJPAUtils.getEntityManager();
            em.getTransaction().begin();
            AppCatalogQueryGenerator generator = new AppCatalogQueryGenerator("ComputeResourceFileSystem", new Object[0][]);
            generator.setParameter("computeResourceId", ids.get("computeResourceId"));
            generator.setParameter("fileSystem", ids.get("fileSystem"));
            Query q = generator.selectQuery(em);
            ComputeResourceFileSystem computeResourceFileSystem = (ComputeResourceFileSystem)q.getSingleResult();
            ComputeResourceFileSystemResource computeResourceFileSystemResource = (ComputeResourceFileSystemResource)AppCatalogJPAUtils.getResource(AppCatalogResourceType.COMPUTE_RESOURCE_FILE_SYSTEM, computeResourceFileSystem);
            em.getTransaction().commit();
            if (em.isOpen()) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                em.close();
            }
            ComputeResourceFileSystemResource computeResourceFileSystemResource2 = computeResourceFileSystemResource;
            return computeResourceFileSystemResource2;
        }
        catch (ApplicationSettingsException e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new AppCatalogException((Throwable)e);
        }
        finally {
            if (em != null && em.isOpen()) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                em.close();
            }
        }
    }

    @Override
    public List<AppCatalogResource> get(String fieldName, Object value) throws AppCatalogException {
        ArrayList<AppCatalogResource> computeResourceFileSystemResources = new ArrayList<AppCatalogResource>();
        EntityManager em = null;
        try {
            em = AppCatalogJPAUtils.getEntityManager();
            em.getTransaction().begin();
            AppCatalogQueryGenerator generator = new AppCatalogQueryGenerator("ComputeResourceFileSystem", new Object[0][]);
            if (fieldName.equals("computeResourceId") || fieldName.equals("path") || fieldName.equals("fileSystem")) {
                generator.setParameter(fieldName, value);
                Query q = generator.selectQuery(em);
                List results = q.getResultList();
                for (Object result : results) {
                    ComputeResourceFileSystem computeResourceFileSystem = (ComputeResourceFileSystem)result;
                    ComputeResourceFileSystemResource computeResourceFileSystemResource = (ComputeResourceFileSystemResource)AppCatalogJPAUtils.getResource(AppCatalogResourceType.COMPUTE_RESOURCE_FILE_SYSTEM, computeResourceFileSystem);
                    computeResourceFileSystemResources.add(computeResourceFileSystemResource);
                }
            } else {
                em.getTransaction().commit();
                if (em.isOpen()) {
                    if (em.getTransaction().isActive()) {
                        em.getTransaction().rollback();
                    }
                    em.close();
                }
                logger.error("Unsupported field name for Compute Resource File System Resource.", (Throwable)new IllegalArgumentException());
                throw new IllegalArgumentException("Unsupported field name for Compute Resource File System Resource.");
            }
            em.getTransaction().commit();
            if (em.isOpen()) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                em.close();
            }
        }
        catch (ApplicationSettingsException e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new AppCatalogException((Throwable)e);
        }
        finally {
            if (em != null && em.isOpen()) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                em.close();
            }
        }
        return computeResourceFileSystemResources;
    }

    @Override
    public List<AppCatalogResource> getAll() throws AppCatalogException {
        return null;
    }

    @Override
    public List<String> getAllIds() throws AppCatalogException {
        return null;
    }

    @Override
    public List<String> getIds(String fieldName, Object value) throws AppCatalogException {
        ArrayList<String> computeResourceFileSystemResourceIDs = new ArrayList<String>();
        EntityManager em = null;
        try {
            em = AppCatalogJPAUtils.getEntityManager();
            em.getTransaction().begin();
            AppCatalogQueryGenerator generator = new AppCatalogQueryGenerator("ComputeResourceFileSystem", new Object[0][]);
            if (fieldName.equals("computeResourceId") || fieldName.equals("path") || fieldName.equals("fileSystem")) {
                generator.setParameter(fieldName, value);
                Query q = generator.selectQuery(em);
                List results = q.getResultList();
                for (Object result : results) {
                    ComputeResourceFileSystem computeResourceFileSystem = (ComputeResourceFileSystem)result;
                    ComputeResourceFileSystemResource computeResourceFileSystemResource = (ComputeResourceFileSystemResource)AppCatalogJPAUtils.getResource(AppCatalogResourceType.COMPUTE_RESOURCE_FILE_SYSTEM, computeResourceFileSystem);
                    computeResourceFileSystemResourceIDs.add(computeResourceFileSystemResource.getComputeResourceId());
                }
            } else {
                em.getTransaction().commit();
                if (em.isOpen()) {
                    if (em.getTransaction().isActive()) {
                        em.getTransaction().rollback();
                    }
                    em.close();
                }
                logger.error("Unsupported field name for Compute Resource File System Resource.", (Throwable)new IllegalArgumentException());
                throw new IllegalArgumentException("Unsupported field name for Compute Resource File System Resource.");
            }
            em.getTransaction().commit();
            if (em.isOpen()) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                em.close();
            }
        }
        catch (ApplicationSettingsException e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new AppCatalogException((Throwable)e);
        }
        finally {
            if (em != null && em.isOpen()) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                em.close();
            }
        }
        return computeResourceFileSystemResourceIDs;
    }

    @Override
    public void save() throws AppCatalogException {
        EntityManager em = null;
        try {
            em = AppCatalogJPAUtils.getEntityManager();
            ComputeResourceFileSystem existingComputeResourceFileSystem = (ComputeResourceFileSystem)em.find(ComputeResourceFileSystem.class, (Object)new ComputeResourceFileSystem_PK(this.computeResourceId, this.fileSystem));
            if (em.isOpen()) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                em.close();
            }
            em = AppCatalogJPAUtils.getEntityManager();
            em.getTransaction().begin();
            ComputeResourceFileSystem computeResourceFileSystem = existingComputeResourceFileSystem == null ? new ComputeResourceFileSystem() : existingComputeResourceFileSystem;
            computeResourceFileSystem.setComputeResourceId(this.getComputeResourceId());
            ComputeResource computeResource = (ComputeResource)em.find(ComputeResource.class, (Object)this.getComputeResourceId());
            computeResourceFileSystem.setComputeResource(computeResource);
            computeResourceFileSystem.setPath(this.getPath());
            computeResourceFileSystem.setFileSystem(this.getFileSystem());
            if (existingComputeResourceFileSystem == null) {
                em.persist((Object)computeResourceFileSystem);
            } else {
                em.merge((Object)computeResourceFileSystem);
            }
            em.getTransaction().commit();
            if (em.isOpen()) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                em.close();
            }
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new AppCatalogException((Throwable)e);
        }
        finally {
            if (em != null && em.isOpen()) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                em.close();
            }
        }
    }

    @Override
    public boolean isExists(Object identifier) throws AppCatalogException {
        if (!(identifier instanceof Map)) {
            logger.error("Identifier should be a map with the field name and it's value");
            throw new AppCatalogException("Identifier should be a map with the field name and it's value");
        }
        HashMap ids = (HashMap)identifier;
        EntityManager em = null;
        try {
            em = AppCatalogJPAUtils.getEntityManager();
            ComputeResourceFileSystem computeResourceFileSystem = (ComputeResourceFileSystem)em.find(ComputeResourceFileSystem.class, (Object)new ComputeResourceFileSystem_PK((String)ids.get("computeResourceId"), (String)ids.get("fileSystem")));
            if (em.isOpen()) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                em.close();
            }
            boolean bl = computeResourceFileSystem != null;
            return bl;
        }
        catch (ApplicationSettingsException e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new AppCatalogException((Throwable)e);
        }
        finally {
            if (em != null && em.isOpen()) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                em.close();
            }
        }
    }

    public String getComputeResourceId() {
        return this.computeResourceId;
    }

    public ComputeResourceResource getComputeHostResource() {
        return this.computeHostResource;
    }

    public String getPath() {
        return this.path;
    }

    public String getFileSystem() {
        return this.fileSystem;
    }

    public void setComputeResourceId(String computeResourceId) {
        this.computeResourceId = computeResourceId;
    }

    public void setComputeHostResource(ComputeResourceResource computeHostResource) {
        this.computeHostResource = computeHostResource;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public void setFileSystem(String fileSystem) {
        this.fileSystem = fileSystem;
    }
}

