/*
 * Decompiled with CFR 0.152.
 */
package org.apache.airavata.api.client;

import org.apache.airavata.api.Airavata;
import org.apache.airavata.model.error.AiravataClientException;
import org.apache.thrift.protocol.TBinaryProtocol;
import org.apache.thrift.protocol.TProtocol;
import org.apache.thrift.transport.TSSLTransportFactory;
import org.apache.thrift.transport.TSocket;
import org.apache.thrift.transport.TTransport;
import org.apache.thrift.transport.TTransportException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AiravataClientFactory {
    private static final Logger logger = LoggerFactory.getLogger(AiravataClientFactory.class);

    public static Airavata.Client createAiravataClient(String serverHost, int serverPort) throws AiravataClientException {
        try {
            TSocket transport = new TSocket(serverHost, serverPort);
            transport.open();
            TBinaryProtocol protocol = new TBinaryProtocol((TTransport)transport);
            return new Airavata.Client((TProtocol)protocol);
        }
        catch (TTransportException e) {
            AiravataClientException exception = new AiravataClientException();
            exception.setParameter("Unable to connect to the server at " + serverHost + ":" + serverPort);
            throw exception;
        }
    }

    public static Airavata.Client createAiravataSecureClient(String serverHost, int serverPort, String trustStorePath, String trustStorePassword, int clientTimeOut) throws AiravataClientException {
        try {
            TSSLTransportFactory.TSSLTransportParameters params = new TSSLTransportFactory.TSSLTransportParameters();
            params.setTrustStore(trustStorePath, trustStorePassword);
            TSocket transport = TSSLTransportFactory.getClientSocket((String)serverHost, (int)serverPort, (int)clientTimeOut, (TSSLTransportFactory.TSSLTransportParameters)params);
            TBinaryProtocol protocol = new TBinaryProtocol((TTransport)transport);
            return new Airavata.Client((TProtocol)protocol);
        }
        catch (TTransportException e) {
            logger.error(e.getMessage(), (Throwable)e);
            AiravataClientException clientError = new AiravataClientException();
            clientError.setParameter("Unable to connect to the server at " + serverHost + ":" + serverPort);
            throw clientError;
        }
    }
}

