/*
 * Decompiled with CFR 0.152.
 */
package eu.unicore.security.wsutil.client;

import eu.unicore.security.wsutil.SecuritySessionUtils;
import eu.unicore.security.wsutil.client.Configurable;
import eu.unicore.security.wsutil.client.ExtendedTDOutHandler;
import eu.unicore.security.wsutil.client.TDOutHandler;
import eu.unicore.util.Log;
import eu.unicore.util.httpclient.IClientConfiguration;
import eu.unicore.util.httpclient.SessionIDProvider;
import java.util.List;
import org.apache.cxf.binding.soap.SoapMessage;
import org.apache.cxf.binding.soap.interceptor.AbstractSoapInterceptor;
import org.apache.cxf.headers.Header;
import org.apache.cxf.message.Message;
import org.apache.cxf.message.MessageUtils;
import org.apache.log4j.Logger;

public class SessionIDOutHandler
extends AbstractSoapInterceptor
implements Configurable {
    private static final Logger log = Log.getLogger("unicore.client", SessionIDOutHandler.class);
    private IClientConfiguration settings;
    private static ThreadLocal<Boolean> skip = new ThreadLocal();

    public SessionIDOutHandler() {
        super("pre-protocol");
        this.getBefore().add(TDOutHandler.class.getName());
        this.getBefore().add(ExtendedTDOutHandler.class.getName());
    }

    public synchronized void handleMessage(SoapMessage message) {
        if (!MessageUtils.isOutbound((Message)message)) {
            return;
        }
        String sessionID = null;
        Boolean doSkip = skip.get();
        if (doSkip != null && doSkip.booleanValue()) {
            log.debug("Security session will not be used for this call");
            SessionIDOutHandler.setSkip(false);
            return;
        }
        String targetUrl = (String)message.getContextualProperty("unicore-security-session-target-url");
        SessionIDProvider idProvider = this.settings.getSessionIDProvider();
        if (idProvider == null) {
            log.debug("No security session provider is installed");
            return;
        }
        sessionID = idProvider.getSessionID(targetUrl, this.settings);
        if (sessionID == null) {
            log.debug("No security session will be used for the request");
            return;
        }
        log.debug("Found session id for the request, using it: " + sessionID);
        Header header = SecuritySessionUtils.buildHeader(sessionID, -1L);
        List h = message.getHeaders();
        h.add(header);
        message.setContextualProperty("reused-unicore-security-session", (Object)sessionID);
    }

    @Override
    public void configure(IClientConfiguration properties) {
        this.settings = properties;
    }

    public static void setSkip(boolean how) {
        skip.set(how);
    }
}

