/*
 * Decompiled with CFR 0.152.
 */
package org.apache.airavata.registry.core.app.catalog.resources;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import org.apache.airavata.common.exception.ApplicationSettingsException;
import org.apache.airavata.registry.core.app.catalog.model.GatewayProfile;
import org.apache.airavata.registry.core.app.catalog.model.StoragePreference;
import org.apache.airavata.registry.core.app.catalog.model.StoragePreferencePK;
import org.apache.airavata.registry.core.app.catalog.resources.AppCatAbstractResource;
import org.apache.airavata.registry.core.app.catalog.resources.AppCatalogResource;
import org.apache.airavata.registry.core.app.catalog.resources.GatewayProfileResource;
import org.apache.airavata.registry.core.app.catalog.util.AppCatalogJPAUtils;
import org.apache.airavata.registry.core.app.catalog.util.AppCatalogQueryGenerator;
import org.apache.airavata.registry.core.app.catalog.util.AppCatalogResourceType;
import org.apache.airavata.registry.cpi.AppCatalogException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StoragePreferenceResource
extends AppCatAbstractResource {
    private static final Logger logger = LoggerFactory.getLogger(StoragePreferenceResource.class);
    private String gatewayId;
    private String storageResourceId;
    private String loginUserName;
    private String fsRootLocation;
    private String resourceCSToken;
    private GatewayProfileResource gatewayProfile;

    public String getLoginUserName() {
        return this.loginUserName;
    }

    public void setLoginUserName(String loginUserName) {
        this.loginUserName = loginUserName;
    }

    public String getGatewayId() {
        return this.gatewayId;
    }

    public void setGatewayId(String gatewayId) {
        this.gatewayId = gatewayId;
    }

    public GatewayProfileResource getGatewayProfile() {
        return this.gatewayProfile;
    }

    public void setGatewayProfile(GatewayProfileResource gatewayProfile) {
        this.gatewayProfile = gatewayProfile;
    }

    public String getResourceCSToken() {
        return this.resourceCSToken;
    }

    public void setResourceCSToken(String resourceCSToken) {
        this.resourceCSToken = resourceCSToken;
    }

    public String getFsRootLocation() {
        return this.fsRootLocation;
    }

    public void setFsRootLocation(String fsRootLocation) {
        this.fsRootLocation = fsRootLocation;
    }

    public String getStorageResourceId() {
        return this.storageResourceId;
    }

    public void setStorageResourceId(String storageResourceId) {
        this.storageResourceId = storageResourceId;
    }

    @Override
    public void remove(Object identifier) throws AppCatalogException {
        if (!(identifier instanceof Map)) {
            logger.error("Identifier should be a map with the field name and it's value");
            throw new AppCatalogException("Identifier should be a map with the field name and it's value");
        }
        HashMap ids = (HashMap)identifier;
        EntityManager em = null;
        try {
            em = AppCatalogJPAUtils.getEntityManager();
            em.getTransaction().begin();
            AppCatalogQueryGenerator generator = new AppCatalogQueryGenerator("StoragePreference", new Object[0][]);
            generator.setParameter("storageResourceId", ids.get("storageResourceId"));
            generator.setParameter("gatewayId", ids.get("gatewayId"));
            Query q = generator.deleteQuery(em);
            q.executeUpdate();
            em.getTransaction().commit();
            if (em.isOpen()) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                em.close();
            }
        }
        catch (ApplicationSettingsException e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new AppCatalogException((Throwable)e);
        }
        finally {
            if (em != null && em.isOpen()) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                em.close();
            }
        }
    }

    @Override
    public AppCatalogResource get(Object identifier) throws AppCatalogException {
        if (!(identifier instanceof Map)) {
            logger.error("Identifier should be a map with the field name and it's value");
            throw new AppCatalogException("Identifier should be a map with the field name and it's value");
        }
        HashMap ids = (HashMap)identifier;
        EntityManager em = null;
        try {
            em = AppCatalogJPAUtils.getEntityManager();
            em.getTransaction().begin();
            AppCatalogQueryGenerator generator = new AppCatalogQueryGenerator("StoragePreference", new Object[0][]);
            generator.setParameter("gatewayId", ids.get("gatewayId"));
            generator.setParameter("storageResourceId", ids.get("storageResourceId"));
            Query q = generator.selectQuery(em);
            StoragePreference preference = (StoragePreference)q.getSingleResult();
            StoragePreferenceResource preferenceResource = (StoragePreferenceResource)AppCatalogJPAUtils.getResource(AppCatalogResourceType.STORAGE_PREFERENCE, preference);
            em.getTransaction().commit();
            if (em.isOpen()) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                em.close();
            }
            StoragePreferenceResource storagePreferenceResource = preferenceResource;
            return storagePreferenceResource;
        }
        catch (ApplicationSettingsException e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new AppCatalogException((Throwable)e);
        }
        finally {
            if (em != null && em.isOpen()) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                em.close();
            }
        }
    }

    @Override
    public List<AppCatalogResource> get(String fieldName, Object value) throws AppCatalogException {
        ArrayList<AppCatalogResource> preferenceResourceList = new ArrayList<AppCatalogResource>();
        EntityManager em = null;
        try {
            em = AppCatalogJPAUtils.getEntityManager();
            em.getTransaction().begin();
            AppCatalogQueryGenerator generator = new AppCatalogQueryGenerator("StoragePreference", new Object[0][]);
            if (fieldName.equals("storageResourceId")) {
                generator.setParameter("storageResourceId", value);
                Query q = generator.selectQuery(em);
                List results = q.getResultList();
                if (results.size() != 0) {
                    for (Object result : results) {
                        StoragePreference preference = (StoragePreference)result;
                        if (preference.getStorageResourceId() == null) continue;
                        StoragePreferenceResource preferenceResource = (StoragePreferenceResource)AppCatalogJPAUtils.getResource(AppCatalogResourceType.STORAGE_PREFERENCE, preference);
                        preferenceResourceList.add(preferenceResource);
                    }
                }
            } else if (fieldName.equals("gatewayId")) {
                generator.setParameter("gatewayId", value);
                Query q = generator.selectQuery(em);
                List results = q.getResultList();
                if (results.size() != 0) {
                    for (Object result : results) {
                        StoragePreference preference = (StoragePreference)result;
                        if (preference.getStorageResourceId() == null) continue;
                        StoragePreferenceResource preferenceResource = (StoragePreferenceResource)AppCatalogJPAUtils.getResource(AppCatalogResourceType.STORAGE_PREFERENCE, preference);
                        preferenceResourceList.add(preferenceResource);
                    }
                }
            } else {
                em.getTransaction().commit();
                if (em.isOpen()) {
                    if (em.getTransaction().isActive()) {
                        em.getTransaction().rollback();
                    }
                    em.close();
                }
                logger.error("Unsupported field name for data storage preference Resource.", (Throwable)new IllegalArgumentException());
                throw new IllegalArgumentException("Unsupported field name for data storage preference Resource.");
            }
            em.getTransaction().commit();
            if (em.isOpen()) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                em.close();
            }
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new AppCatalogException((Throwable)e);
        }
        finally {
            if (em != null && em.isOpen()) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                em.close();
            }
        }
        return preferenceResourceList;
    }

    @Override
    public List<AppCatalogResource> getAll() throws AppCatalogException {
        return null;
    }

    @Override
    public List<String> getAllIds() throws AppCatalogException {
        return null;
    }

    @Override
    public List<String> getIds(String fieldName, Object value) throws AppCatalogException {
        logger.error("Unsupported for objects with a composite identifier");
        throw new AppCatalogException("Unsupported for objects with a composite identifier");
    }

    @Override
    public void save() throws AppCatalogException {
        EntityManager em = null;
        try {
            em = AppCatalogJPAUtils.getEntityManager();
            StoragePreference existingPreference = (StoragePreference)em.find(StoragePreference.class, (Object)new StoragePreferencePK(this.gatewayId, this.storageResourceId));
            if (em.isOpen()) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                em.close();
            }
            em = AppCatalogJPAUtils.getEntityManager();
            em.getTransaction().begin();
            GatewayProfile gatewayProf = (GatewayProfile)em.find(GatewayProfile.class, (Object)this.gatewayId);
            if (existingPreference != null) {
                existingPreference.setStorageResourceId(this.storageResourceId);
                existingPreference.setGatewayId(this.gatewayId);
                existingPreference.setGatewayProfile(gatewayProf);
                existingPreference.setLoginUserName(this.loginUserName);
                existingPreference.setComputeResourceCSToken(this.resourceCSToken);
                existingPreference.setFsRootLocation(this.fsRootLocation);
                em.merge((Object)existingPreference);
            } else {
                StoragePreference resourcePreference = new StoragePreference();
                resourcePreference.setStorageResourceId(this.storageResourceId);
                resourcePreference.setGatewayId(this.gatewayId);
                resourcePreference.setGatewayProfile(gatewayProf);
                resourcePreference.setLoginUserName(this.loginUserName);
                resourcePreference.setComputeResourceCSToken(this.resourceCSToken);
                resourcePreference.setFsRootLocation(this.fsRootLocation);
                em.persist((Object)resourcePreference);
            }
            em.getTransaction().commit();
            if (em.isOpen()) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                em.close();
            }
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new AppCatalogException((Throwable)e);
        }
        finally {
            if (em != null && em.isOpen()) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                em.close();
            }
        }
    }

    @Override
    public boolean isExists(Object identifier) throws AppCatalogException {
        if (!(identifier instanceof Map)) {
            logger.error("Identifier should be a map with the field name and it's value");
            throw new AppCatalogException("Identifier should be a map with the field name and it's value");
        }
        HashMap ids = (HashMap)identifier;
        EntityManager em = null;
        try {
            em = AppCatalogJPAUtils.getEntityManager();
            StoragePreference existingPreference = (StoragePreference)em.find(StoragePreference.class, (Object)new StoragePreferencePK((String)ids.get("gatewayId"), (String)ids.get("storageResourceId")));
            if (em.isOpen()) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                em.close();
            }
            boolean bl = existingPreference != null;
            return bl;
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new AppCatalogException((Throwable)e);
        }
        finally {
            if (em != null && em.isOpen()) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                em.close();
            }
        }
    }
}

