/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.store.jdbc.dialect;

import org.apache.lucene.store.jdbc.dialect.Dialect;

public class PostgreSQLDialect
extends Dialect {
    public boolean supportsForUpdate() {
        return true;
    }

    public boolean supportTransactionalScopedBlobs() {
        return true;
    }

    public boolean supportsTableExists() {
        return true;
    }

    public String sqlTableExists(String catalog, String schemaName) {
        if (schemaName == null || schemaName.length() == 0) {
            schemaName = "public";
        }
        return "select tablename from pg_tables where schemaname = '" + schemaName + "' and lower(tablename) = ?";
    }

    public boolean supportsCurrentTimestampSelection() {
        return true;
    }

    public boolean isCurrentTimestampSelectStringCallable() {
        return false;
    }

    public boolean useInputStreamToInsertBlob() {
        return false;
    }

    public String getCurrentTimestampSelectString() {
        return "select now()";
    }

    public String getVarcharType(int length) {
        return "varchar(" + length + ")";
    }

    public String getBlobType(long length) {
        return "oid";
    }

    public String getNumberType() {
        return "int4";
    }

    public String getTimestampType() {
        return "timestamp";
    }

    public String getCurrentTimestampFunction() {
        return "current_timestamp";
    }

    public String getBitType() {
        return "bool";
    }
}

