/*
 * Decompiled with CFR 0.152.
 */
package org.jolokia.server.core.restrictor.policy;

import java.util.HashSet;
import java.util.Set;
import org.jolokia.server.core.restrictor.policy.AbstractChecker;
import org.jolokia.server.core.util.RequestType;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class RequestTypeChecker
extends AbstractChecker<RequestType> {
    private Set<RequestType> typeSet;

    public RequestTypeChecker(Document pDoc) {
        NodeList nodes = pDoc.getElementsByTagName("commands");
        if (nodes.getLength() > 0) {
            this.typeSet = new HashSet<RequestType>();
        }
        for (int i = 0; i < nodes.getLength(); ++i) {
            Node node = nodes.item(i);
            NodeList childs = node.getChildNodes();
            for (int j = 0; j < childs.getLength(); ++j) {
                Node commandNode = childs.item(j);
                if (commandNode.getNodeType() != 1) continue;
                this.assertNodeName(commandNode, "command");
                String typeName = commandNode.getTextContent().trim();
                RequestType type = RequestType.getTypeByName(typeName);
                this.typeSet.add(type);
            }
        }
    }

    @Override
    public boolean check(RequestType pType) {
        return this.typeSet == null || this.typeSet.contains((Object)pType);
    }
}

