/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.protocol.mqtt;

import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.core.protocol.mqtt.MQTTConnection;
import org.apache.activemq.artemis.core.protocol.mqtt.MQTTLogger;
import org.apache.activemq.artemis.core.protocol.mqtt.MQTTSession;
import org.apache.activemq.artemis.core.server.MessageReference;
import org.apache.activemq.artemis.core.server.ServerConsumer;
import org.apache.activemq.artemis.spi.core.protocol.SessionCallback;
import org.apache.activemq.artemis.spi.core.remoting.ReadyListener;

public class MQTTSessionCallback
implements SessionCallback {
    private final MQTTSession session;
    private final MQTTConnection connection;
    private final int defaultMaximumInFlightPublishMessages;

    public MQTTSessionCallback(MQTTSession session, MQTTConnection connection, int defaultMaximumInFlightPublishMessages) throws Exception {
        this.session = session;
        this.connection = connection;
        this.defaultMaximumInFlightPublishMessages = defaultMaximumInFlightPublishMessages;
    }

    public boolean supportsDirectDelivery() {
        return false;
    }

    public boolean isWritable(ReadyListener callback, Object protocolContext) {
        return this.connection.isWritable(callback);
    }

    public int sendMessage(MessageReference ref, ServerConsumer consumer, int deliveryCount) {
        try {
            this.session.getMqttPublishManager().sendMessage(ref.getMessage().toCore(), consumer, deliveryCount);
        }
        catch (Exception e) {
            MQTTLogger.LOGGER.unableToSendMessage(ref, e);
        }
        return 1;
    }

    public boolean updateDeliveryCountAfterCancel(ServerConsumer consumer, MessageReference ref, boolean failed) {
        return false;
    }

    public int sendLargeMessageContinuation(ServerConsumer consumerID, byte[] body, boolean continues, boolean requiresResponse) {
        return 1;
    }

    public int sendLargeMessage(MessageReference ref, ServerConsumer consumer, long bodySize, int deliveryCount) {
        return this.sendMessage(ref, consumer, deliveryCount);
    }

    public void disconnect(ServerConsumer consumer, String errorMessage) {
        try {
            consumer.removeItself();
        }
        catch (Exception e) {
            MQTTLogger.LOGGER.errorDisconnectingConsumer(e);
        }
    }

    public void afterDelivery() throws Exception {
    }

    public void browserFinished(ServerConsumer consumer) {
    }

    public boolean hasCredits(ServerConsumer consumerID) {
        return this.hasCredits(consumerID, null);
    }

    public boolean hasCredits(ServerConsumer consumerID, MessageReference ref) {
        int maxInFlightPublishMessages;
        int n = maxInFlightPublishMessages = this.connection.getReceiveMaximum() > 0 ? this.connection.getReceiveMaximum() : this.defaultMaximumInFlightPublishMessages;
        return ref == null || !ref.isDurable() || maxInFlightPublishMessages <= 0 || this.session.getState().getOutboundStore().getSendQuota() < maxInFlightPublishMessages;
    }

    public void sendProducerCreditsMessage(int credits, SimpleString address) {
    }

    public void sendProducerCreditsFailMessage(int credits, SimpleString address) {
    }

    public void closed() {
    }
}

