/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.protocol.amqp.connect.bridge;

import java.lang.invoke.MethodHandles;
import org.apache.activemq.artemis.core.server.plugin.ActiveMQServerBasePlugin;
import org.apache.activemq.artemis.protocol.amqp.connect.bridge.AMQPBridgeConfiguration;
import org.apache.activemq.artemis.protocol.amqp.connect.bridge.AMQPBridgeManagementSupport;
import org.apache.activemq.artemis.protocol.amqp.connect.bridge.AMQPBridgeManager;
import org.apache.activemq.artemis.protocol.amqp.connect.bridge.AMQPBridgeMetrics;
import org.apache.activemq.artemis.protocol.amqp.connect.bridge.AMQPBridgePolicyManager;
import org.apache.activemq.artemis.protocol.amqp.connect.bridge.AMQPBridgeSenderConfiguration;
import org.apache.activemq.artemis.protocol.amqp.connect.bridge.AMQPBridgeType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AMQPBridgeToPolicyManager
extends AMQPBridgePolicyManager
implements ActiveMQServerBasePlugin {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    protected volatile AMQPBridgeSenderConfiguration configuration;

    public AMQPBridgeToPolicyManager(AMQPBridgeManager bridge, AMQPBridgeMetrics metrics, String policyName, AMQPBridgeType policyType) {
        super(bridge, metrics, policyName, policyType);
    }

    @Override
    protected void handleManagerInitialized() {
        this.server.registerBrokerPlugin((ActiveMQServerBasePlugin)this);
        try {
            AMQPBridgeManagementSupport.registerBridgePolicyManager(this);
        }
        catch (Exception e) {
            logger.trace("Error while attempting to add sender policy control to management", (Throwable)e);
        }
    }

    @Override
    protected void handleManagerStarted() {
        if (this.isActive()) {
            this.scanManagedResources();
        }
    }

    @Override
    protected void handleManagerStopped() {
        this.safeCleanupManagerResources();
    }

    @Override
    protected void handleManagerShutdown() {
        this.server.unRegisterBrokerPlugin((ActiveMQServerBasePlugin)this);
        try {
            AMQPBridgeManagementSupport.unregisterBridgePolicyManager(this);
        }
        catch (Exception e) {
            logger.trace("Error while attempting to remove sender policy control from management", (Throwable)e);
        }
        this.safeCleanupManagerResources();
    }

    @Override
    protected void handleConnectionInterrupted() {
        this.safeCleanupManagerResources();
    }

    @Override
    protected void handleConnectionRestored(AMQPBridgeConfiguration configuration) {
        this.configuration = new AMQPBridgeSenderConfiguration(configuration, this.getPolicy().getProperties());
        if (this.isActive()) {
            this.scanManagedResources();
        }
    }

    protected abstract void scanManagedResources();

    protected abstract void safeCleanupManagerResources();
}

