/*
 * Decompiled with CFR 0.152.
 */
package org.jolokia.service.serializer.json;

import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.Deque;
import java.util.Iterator;
import java.util.LinkedList;
import javax.management.AttributeNotFoundException;
import org.jolokia.json.JSONArray;
import org.jolokia.server.core.service.serializer.ValueFaultHandler;
import org.jolokia.service.serializer.json.Extractor;
import org.jolokia.service.serializer.json.ObjectToJsonConverter;
import org.jolokia.service.serializer.object.StringToObjectConverter;

public class CollectionExtractor
implements Extractor {
    @Override
    public Class<?> getType() {
        return Collection.class;
    }

    @Override
    public Object extractObject(ObjectToJsonConverter pConverter, Object pValue, Deque<String> pPathParts, boolean jsonify) throws AttributeNotFoundException {
        Collection collection = (Collection)pValue;
        String pathPart = pPathParts.isEmpty() ? null : pPathParts.pop();
        int length = pConverter.getCollectionLength(collection.size());
        if (pathPart != null) {
            return this.extractWithPath(pConverter, collection, pPathParts, jsonify, pathPart, length);
        }
        return jsonify ? this.extractListAsJson(pConverter, collection, pPathParts, length) : collection;
    }

    private Object extractWithPath(ObjectToJsonConverter pConverter, Collection<?> pCollection, Deque<String> pPathParts, boolean pJsonify, String pPathPart, int pLength) throws AttributeNotFoundException {
        try {
            int idx = Integer.parseInt(pPathPart);
            return pConverter.extractObject(this.getElement(pCollection, idx, pLength), pPathParts, pJsonify);
        }
        catch (NumberFormatException exp) {
            ValueFaultHandler faultHandler = pConverter.getValueFaultHandler();
            return faultHandler.handleException((Throwable)new AttributeNotFoundException("Index '" + pPathPart + "' is not numeric for accessing list"));
        }
        catch (IndexOutOfBoundsException exp) {
            ValueFaultHandler faultHandler = pConverter.getValueFaultHandler();
            return faultHandler.handleException((Throwable)new AttributeNotFoundException("Index '" + pPathPart + "' is out-of-bound for a list of size " + pLength));
        }
    }

    private Object getElement(Collection<?> pCollection, int pIdx, int pLength) {
        Iterator<?> it = pCollection.iterator();
        for (int i = 0; it.hasNext() && i < pLength; ++i) {
            Object val = it.next();
            if (i != pIdx) continue;
            return val;
        }
        throw new IndexOutOfBoundsException("Collection index " + pIdx + " larger than size " + pLength);
    }

    private Object extractListAsJson(ObjectToJsonConverter pConverter, Collection<?> pCollection, Deque<String> pPathParts, int pLength) throws AttributeNotFoundException {
        JSONArray ret = new JSONArray(pCollection.size());
        Iterator<?> it = pCollection.iterator();
        for (int i = 0; i < pLength; ++i) {
            Object val = it.next();
            LinkedList<String> path = new LinkedList<String>(pPathParts);
            ret.add(pConverter.extractObject(val, path, true));
        }
        return ret;
    }

    @Override
    public Object setObjectValue(StringToObjectConverter pConverter, Object pInner, String pAttribute, Object pValue) throws IllegalAccessException, InvocationTargetException {
        throw new IllegalArgumentException("A collection (beside Lists and Maps) cannot be modified");
    }

    @Override
    public boolean canSetValue() {
        return false;
    }
}

